/***************************************************************************
*   Copyright (C) 2010 by
*    Mika Isojärvi <bungler29@gmail.com>
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _SOUNDPLAYER_H
#define _SOUNDPLAYER_H

#include <SFML/Audio.hpp>

#include <map>
#include <string>
#include "pauseclock_rt.h"

class sound_delay {
	public:
		sound_delay(sf::Sound* _s, double _delay);
		bool stopped() { return started && s->GetStatus() == sf::Sound::Stopped; }
		void update();
		void pause();
		void unpause();

		sf::Sound *s;
	private:
		pclock_realtime clock;
		double delay;
		bool started;
};

class soundplayer {
	public:
		soundplayer();
		~soundplayer();
		bool play_sound(std::string, bool loop = false, double delay = 0);
		void set_volume(double);
		double get_volume() { return volume; }
		void update();
		void stop_sound(std::string);
		void pause();
		void unpause();
	private:
		void load(std::string name, std::string file);
		double volume;
		std::map<std::string, sf::SoundBuffer*> sound_buffers;
		std::multimap<std::string, sound_delay> playing_sounds;
};

#endif
