/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "settingsmenu.h"
#include "spellhotkey.h"
#include "mainmenu.h"
#include "keynames.h"

settings_menu::settings_menu(Gui::Rect r) : Gui::Container(r)
{
	Gui::VerticalList *list = new Gui::VerticalList(Gui::Rect(0, 0, 600, 600));

	Gui::TextLabel *label = new Gui::TextLabel("Settings");
	label->SetFontColor(sf::Color(0x40, 0x80, 0x80));
	list->AddCenter(label);

	Gui::Container *settings = new Gui::Container(Gui::Rect(0, 0, 600, 400));

	Gui::HorizontalList *blist = new Gui::HorizontalList(Gui::Rect(150, 0, 300, 40));

	positional = new Gui::Button("Positional");
	main_menu::set_button(positional);
	hotkey = new Gui::Button("Hotkey");
	main_menu::set_button(hotkey);

	blist->Add(positional)->Add(hotkey);
	settings->Add(blist);

	key_cont = new Gui::Container(Gui::Rect(150, 0, 600, 300));

	for(size_t a = 0; a < HOTKEYS; a++) {
		Gui::Button *k = new Gui::Button(Gui::Rect(0, 50 + 35 * a, 200, 30));
		main_menu::set_button(k);
		keys.push_back(k);
		key_cont->Add(k);
	}

	settings->Add(key_cont);
	
	list->Add(settings);

	back = new Gui::Button("Back");
	main_menu::set_button(back);
	list->AddCenter(back);

	this->AddCenter(list);

	press_key = new Gui::Container(Gui::Rect(0, 0, 300, 220), sf::Color(40, 40, 150, 210));
	press_key->DrawBG(true);
	press_key->Hide();

	press_key_label = new Gui::TextLabel("Press key");

	press_key->AddCenter(press_key_label);

	this->AddCenter(press_key);
	SetActionListener(this);
	apply_config();
}

void settings_menu::apply_config()
{
	config &conf = config::get();

	switch(conf.get_value<int>("spell_hotkey_mode")) {
		case spell_hotkey_handler::hotkey:
			positional->SetBorderColor(sf::Color(0, 0x50, 0));
			hotkey->SetBorderColor(sf::Color(0x50, 0x50, 0));
			key_cont->Hide();
		break;
		case spell_hotkey_handler::positional:
			positional->SetBorderColor(sf::Color(0x50, 0x50, 0));
			hotkey->SetBorderColor(sf::Color(0, 0x50, 0));
			key_cont->Show();
			update_keys();
		break;
	}
}

void settings_menu::update_keys()
{
	config &conf = config::get();
	for(unsigned int a = 0; a < HOTKEYS; a++) {
		std::stringstream k;
		k << "key" << a;

		std::string name = sf::Key::names[conf.get_value<int>(k.str())];
		std::stringstream str;
		str << "Key " << (a+1) << ": " << name;
		keys[a]->SetText(str.str());
		keys[a]->SetRect(Gui::Rect(0, 50 + 35 * a, 200, 30));
	}
} 

void settings_menu::ButtonClick(Gui::ID srcid)
{
	config &conf = config::get();
	if(srcid == positional->GetID()) {
		conf.set_value<int>("spell_hotkey_mode", spell_hotkey_handler::positional);
		apply_config();
	} else if(srcid == hotkey->GetID()) {
		conf.set_value<int>("spell_hotkey_mode", spell_hotkey_handler::hotkey);
		apply_config();
	} else if(srcid == back->GetID()) {
		Gui::ActionListener *l = parent->GetListener();
		Hide();
		if(l) 
			l->ButtonClick(srcid);
	} else {
		for(size_t a = 0; a < keys.size(); a++) {
			if(srcid == keys[a]->GetID()) {
				key_set = a;
				Lock(press_key->GetID());
				key_cont->UnFocus();
				SetFocus(press_key->GetID());
				press_key->Show();
				press_key->Raise();
				wait_key = true;
				break;
			}
		}
	}
}

void settings_menu::KeyDown(Gui::ID srcid, Gui::Key key)
{
	config &conf = config::get();
	if(wait_key) {
		Lock(Gui::ID_NONE);
		press_key->Hide();
		std::stringstream s;
		s << "key" << key_set;
		conf.set_value<int>(s.str(), key.Code);
		apply_config();
		wait_key = true;
	}
}

