/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _SETTINGS_H
#define _SETTINGS_H

/*
 * Gui yms. settings in one header
 * Could add fancy loading from file or something similar
 *
 * Might be smart to also put things like exp requirements here
 */

// Size of whole window
const int SCREEN_W = 1280;
const int SCREEN_H = 720;
// 1024/768 = 4/3 ???
// pixels near vertical borders are really sad pixels

// The length of one time step in seconds
static const float DT = 0.02f;

const int SIDEBAR_W = 150;
const int BUTTONS_ROWS = 4;
const int BUTTONS_PER_ROW = 3;

const int TILE_W = 32, TILE_H = 32;
const int OBJMAP_TILE_W = 32, OBJMAP_TILE_H = 32;

const float SELECT_MUSHROOM_RANGE = 30.0f;
const float SELECT_CC_RANGE = 40.0f;
const float SELECT_ANT_RANGE = 30.0f;
const float SELECT_ANT_HEAP_RANGE = 40.0f;
const float GOAL_WIN_RANGE = 130.0f;

const unsigned int HOTKEYS = 6;

const int VERSION = 1;

extern const char *version_strings[];

#endif
