/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "sbox.h"
#include "animation.h"
#include "world.h"
#include "settings.h"
#include <cmath>

button_widget::button_widget(bool show_hotkey) : Gui::VerticalList(Gui::Rect(1, 0, 
						(32+10)*BUTTONS_PER_ROW, (32+11)*BUTTONS_ROWS - 11), 11)
{
	spell_buttons.reserve(BUTTONS_ROWS * BUTTONS_PER_ROW);
	
	for(int a = 0; a < BUTTONS_ROWS; a++) {
		Gui::HorizontalList *button_row = new Gui::HorizontalList(Gui::Rect(0, 0, GetW()-2, 32), 9);
		for(int b = 0; b < BUTTONS_PER_ROW; b++) {
			spell_buttons.push_back(new sbutton(show_hotkey));
			button_row->Add(spell_buttons.back());
		}
		Add(button_row);
	}
}

void button_widget::update(world &w)
{
	for(size_t a = 0; a < spell_buttons.size(); a++) {
		spell_buttons[a]->update(w);
	}
}

void button_widget::selected_change(world &w)
{
	selectable *selected = w.get_selected();
	std::vector<spell> &spells = selected->get_spells();
	for(size_t a = 0; a < spell_buttons.size(); a++) {
		if(a >= spells.size()) {
			spell_buttons[a]->set_to_dummy();
		} else {
			animation anim(w.anim_loader->get_animation(spells[a].get_animation()));
			anim.set_mode("icon");
			spell_buttons[a]->change_spell(anim.get_frame(), spells[a], selected);
		}
	}
}

bool button_widget::get_spell(Gui::ID button_id, spell &spell)
{
	for(size_t a = 0; a < spell_buttons.size(); a++) {
		if(spell_buttons[a]->GetID() == button_id) {
			spell = spell_buttons[a]->get_spell();
			return true;
		}
	}
	return false;
}

const int sbox::list_top = 110;
const int sbox::list_left = 2;

sbox::sbox(Gui::Rect rect, bool _show_hotkey) : Gui::Container(rect), show_hotkey(_show_hotkey)
{
	creature_tab = new Gui::Container(Gui::Rect(0, 0, SIDEBAR_W-2, 300-2));
	mushroom_tab = new Gui::Container(Gui::Rect(0, 0, SIDEBAR_W-2, 300-2));
	cc_tab = new Gui::Container(Gui::Rect(0, 0, SIDEBAR_W-2, 300-2));
	ant_tab = new Gui::Container(Gui::Rect(0, 0, SIDEBAR_W-2, 300-2));
	heap_tab = new Gui::Container(Gui::Rect(0, 0, SIDEBAR_W-2, 300-2));	

	init_creature_tab();
	init_mushroom_tab();
	init_cc_tab();
	init_ant_tab();
	init_heap_tab();

	Add(creature_tab)->Add(mushroom_tab)->Add(cc_tab)->Add(ant_tab)->Add(heap_tab);
	hide_tabs();	
}

void sbox::init_creature_tab()
{
	c_buttons = new button_widget(show_hotkey);
	creature_tab->Add(c_buttons);
	
	c_v_list = new Gui::VerticalList(Gui::Rect(list_left, list_top, SIDEBAR_W-4, 300-14), 1);

	c_kills = new Gui::TextLabel();
	c_kills->SetFontColor(sf::Color::White);
	c_kills->SetSize(13);
	
	c_casts = new Gui::TextLabel();
	c_casts->SetFontColor(sf::Color::White);
	c_casts->SetSize(13);
	
	c_m = new Gui::TextLabel();
	c_m->SetFontColor(sf::Color::White);
	c_m->SetSize(13);
	
	c_dead_m = new Gui::TextLabel();
	c_dead_m->SetFontColor(sf::Color::White);
	c_dead_m->SetSize(13);
		
	c_wind = new Gui::TextLabel();
	c_wind->SetFontColor(sf::Color::White);
	c_wind->SetSize(13);
	
	c_v_list->Add(c_kills)->Add(c_casts)->Add(c_m)->Add(c_dead_m)->Add(c_wind);

	creature_tab->Add(c_v_list);
}

void sbox::init_mushroom_tab()
{
	m_buttons = new button_widget(show_hotkey);
	mushroom_tab->Add(m_buttons);

	m_v_list = new Gui::VerticalList(Gui::Rect(list_left, list_top, SIDEBAR_W-4, 300-14), 1);

	m_type = new Gui::TextLabel();
	m_hp  = new Gui::TextLabel();
	m_energy = new Gui::TextLabel();
	m_str = new Gui::TextLabel();
	m_mana = new Gui::TextLabel();
	m_dur = new Gui::TextLabel();
	m_type->SetSize(15);
	m_hp->SetSize(15);
	m_energy->SetSize(15);
	m_str->SetSize(12);
	m_mana->SetSize(12);
	m_dur->SetSize(12);
	m_type->SetFontColor(sf::Color::Blue);
	m_hp->SetFontColor(sf::Color::Red);
	m_energy->SetFontColor(sf::Color::Blue);
	m_str->SetFontColor(sf::Color::Red);
	m_mana->SetFontColor(sf::Color::Green);
	m_dur->SetFontColor(sf::Color::Blue);
	m_v_list->Add(m_type);
	m_v_list->Add(m_hp);
	m_v_list->Add(m_energy);
	m_v_list->Add(m_str);
	m_v_list->Add(m_mana);
	m_v_list->Add(m_dur);

	mushroom_tab->Add(m_v_list);
}

void sbox::init_cc_tab()
{
	cc_buttons = new button_widget(show_hotkey);
	cc_tab->Add(cc_buttons);

	cc_v_list = new Gui::VerticalList(Gui::Rect(list_left, list_top, SIDEBAR_W-4, 300-14), 1);

	cc_hp = new Gui::TextLabel();
	cc_energy = new Gui::TextLabel();
	cc_hp->SetSize(15);
	cc_energy->SetSize(15);
	cc_hp->SetFontColor(sf::Color::Red);
	cc_energy->SetFontColor(sf::Color::Blue);

	cc_v_list->Add(cc_hp)->Add(cc_energy);
	cc_tab->Add(cc_v_list);
}

void sbox::init_ant_tab() 
{
	a_v_list = new Gui::VerticalList(Gui::Rect(list_left,list_top, SIDEBAR_W-4, 300-14), 1);
	a_level = new Gui::TextLabel();
	a_hp = new Gui::TextLabel();
	
	a_hp->SetSize(15);
	a_hp->SetFontColor(sf::Color::Red);
	a_level->SetSize(15);
	a_level->SetFontColor(sf::Color::Blue);
	
	a_v_list->Add(a_level)->Add(a_hp);
	ant_tab->Add(a_v_list);
	
}
void sbox::init_heap_tab() 
{
	h_v_list = new Gui::VerticalList(Gui::Rect(list_left,list_top, SIDEBAR_W-4, 300-14), 1);
	h_waves = new Gui::TextLabel();
	h_waves->SetFontColor(sf::Color::White);
	h_waves->SetSize(13);
	
	h_level = new Gui::TextLabel();
	h_level->SetFontColor(sf::Color::White);
	h_level->SetSize(13);
	
	h_num = new Gui::TextLabel();
	h_num->SetFontColor(sf::Color::White);
	h_num->SetSize(13);
	
	h_min = new Gui::TextLabel();
	h_min->SetFontColor(sf::Color::White);
	h_min->SetSize(13);

	h_max = new Gui::TextLabel();
	h_max->SetFontColor(sf::Color::White);
	h_max->SetSize(13);


	h_v_list->Add(h_waves)->Add(h_level)->Add(h_num)->Add(h_min)->Add(h_max);
	heap_tab->Add(h_v_list);
}

void sbox::view_creature_tab(world &w)
{
	creature_tab->Show();
	c_buttons->selected_change(w);
}

void sbox::view_mushroom_tab(world &w)
{
	mushroom_tab->Show();
	m_buttons->selected_change(w);
}

void sbox::view_cc_tab(world &w)
{
	cc_tab->Show();
	cc_buttons->selected_change(w);
}

void sbox::view_ant_tab(world &w)
{
	ant_tab->Show();
}
void sbox::view_heap_tab(world &w)
{
	heap_tab->Show();
}

void sbox::update(world &w)
{
	hide_tabs();
	creature *cre = dynamic_cast<creature*>(w.get_selected());
	mushroom *mush = dynamic_cast<mushroom*>(w.get_selected());
	command_center *cc = dynamic_cast<command_center*>(w.get_selected());
	ant *a = dynamic_cast<ant*>(w.get_selected());
	ant_heap *h = dynamic_cast<ant_heap*>(w.get_selected());
	
	if(cre) {
		view_creature_tab(w);
	} else if(mush) {
		view_mushroom_tab(w);
	} else if(cc) {
		view_cc_tab(w);
	} else if(a) {
		view_ant_tab(w);
	} else if(h) {
		view_heap_tab(w);
	}
	
	if(cre) {
		c_buttons->update(w);
		c_kills->SetLabel(w.killed_ants_string());
		c_casts->SetLabel(w.casted_spells_string());
		c_m->SetLabel(w.current_mushrooms_string());
		c_dead_m->SetLabel(w.died_mushrooms_string());
		c_wind->SetLabel(w.wind_string());
	}
	if(mush) {
		m_type->SetLabel(mush->type_string());
		m_hp->SetLabel(mush->hp_string());
		m_energy->SetLabel(mush->energy_string());
		m_str->SetLabel(mush->str_string());
		m_mana->SetLabel(mush->mana_string());
		m_dur->SetLabel(mush->dur_string());

		m_buttons->update(w);
	}
	if(cc) {
		cc_hp->SetLabel(cc->hp_string());
		cc_energy->SetLabel(cc->energy_string());
		cc_buttons->update(w);
	}
	if(a) {
		a_hp->SetLabel(a->hp_string());
		a_level->SetLabel(a->level_string());
	}
	if(h) {
		h_waves->SetLabel(h->wave_string());
		h_level->SetLabel(h->level_string());
		h_num->SetLabel(h->how_many_string());
		h_min->SetLabel(h->min_time_string());
		h_max->SetLabel(h->max_time_string());
	}

}

bool sbox::get_spell(Gui::ID button_id, spell &_spell)
{
	if(c_buttons->get_spell(button_id, _spell))
		return true;
	if(m_buttons->get_spell(button_id, _spell))
		return true;
	if(cc_buttons->get_spell(button_id, _spell))
		return true;
	return false;
}
	
void sbox::hide_tabs()
{
	creature_tab->Hide();
	mushroom_tab->Hide();
	cc_tab->Hide();
	ant_tab->Hide();
	heap_tab->Hide();
}

