/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "replay.h"
#include "record.h"

int main(int argc, const char *argv[])
{
	if(argc < 2) {
		std::cout << "Usage: " << argv[0] << " replayfile" << std::endl;
		return 5;
	}

	record rec;

	try {
		rec.read(argv[1]);
		replay rep(rec, false);
		rep.eval();
	} catch (rec_version_exception &e) {
		return 1;
	} catch (rec_exception &e) {
		return 2;
	}
}
