/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _POPUP_H
#define _POPUP_H

#include "gui.h"

class popup : public Gui::Window, public Gui::ActionListener {
	public:
		enum type_t {
			ok,
			text_box,
			twobuttons
		};

		popup(Gui::Rect, type_t);

		int ret_val() { return ret; }
		void set_text(std::vector<std::string> text);
		void set_field_text(const std::string &);
		std::string get_text();
		type_t get_type() { return type; }

		virtual void ButtonClick(Gui::ID srcid);
	private:
		type_t type;
		int ret;

		Gui::TextList *text;
		Gui::Button *button;
		Gui::Button *sec_button;
		Gui::TextField *field;
};

#endif

