/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _PAUSECLOCK_H
#define _PAUSECLOCK_H

#include "settings.h"

// be careful that you don't accidentially pause pclock
class pclock {
	public:
		pclock() : paused(false), t(0) { }

		void pause()
		{ 
			if(!paused) {
				paused = true; 
			}
		}

		void unpause() 
		{
			if(paused) {
				paused = false;
			}
		}

		void reset() 
		{ 
			t = 0; 
		}

		void add(float dt)
		{
			t += dt;
		}

		void step()
		{
			if(!paused)
				t += DT;
		}

		float get_time() const 
		{
			return t;
		}
	private:
		bool paused;
		float t;
};

#endif
