/***************************************************************************
*   Copyright (C) 2010 by
*    Mika Isojärvi <bungler29@gmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "musicplayer.h"

void musicplayer::update()
{
	if(music.GetStatus() == sf::Sound::Stopped && playing){
		int random = sf::Randomizer::Random(0, playlists[current_playlist].size()-1);
		playlist_iterator p = playlists[current_playlist].begin();
		for(int k = 0; k < random; k++){
			p++;
		}
		music.OpenFromFile(p->second);
		music.Play();
	}

}

musicplayer::musicplayer()
{
	playing = true;
	music.SetVolume(75.0);
	music.SetLoop(false);

	playlist start_menu_pl;
	playlist griffin, unicorn, minotaur;
	playlist victory, defeat;

	start_menu_pl["spectrial"] = "music/menu/Spectrial.ogg";
	playlists["start_menu"] = start_menu_pl;

	griffin["ambuscade"] = "music/griffin/Mattias Westlund - Ambuscade.ogg";
	griffin["through the gates"] = "music/griffin/Mattias Westlund - Through the Gates.ogg";
	griffin["exploration"] = "music/griffin/Mattias Westlund - Exploration.ogg";
	playlists["griffin"] = griffin;

	unicorn["cosmo"] = "music/unicorn/Cosmo.ogg";
	unicorn["nostalgia"] = "music/unicorn/Nostalgia.ogg";
	unicorn["victory"] = "music/unicorn/Victory.ogg";
	playlists["unicorn"] = unicorn;

	minotaur["isang tao"] = "music/minotaur/Isang Tao.ogg";
	minotaur["my bob's bule eyes"] = "music/minotaur/My Bob's Blue Eyes.ogg";
	playlists["minotaur"] = minotaur;

	victory["heroes"] = "music/victory/Heroes.ogg"; 
	playlists["victory"] = victory;

	defeat["the death of magic"] = "music/defeat/The Death of Magic.ogg";
	playlists["defeat"] = defeat;
}

musicplayer::~musicplayer()
{
}

void musicplayer::set_playlist(std::string playlist_name)
{
	current_playlist = playlist_name;
	playing = true;
	std::map<std::string, playlist>::iterator i = playlists.find(playlist_name);
	if(i != playlists.end()){
		int random = sf::Randomizer::Random(0, i->second.size()-1);
		playlist_iterator p = i->second.begin();
		for(int k = 0; k < random; k++){
			p++;
		}
		current_music = p->second;
		music.OpenFromFile(p->second);
		music.Play();
	}
}


void musicplayer::set_music(std::string playlist_name, std::string song_name)
{
	current_playlist = playlist_name;
	current_music = song_name;
	playing = true;
	std::map<std::string, playlist>::iterator i = playlists.find(playlist_name);
	if(i != playlists.end()){
		playlist_iterator p = i->second.find(song_name);
		if(p != i->second.end()){
			music.OpenFromFile(p->second);
			music.Play();
		}
	}
}

void musicplayer::set_volume(float volume)
{
	this->volume = volume;
	music.SetVolume(volume);
}

void musicplayer::stop()
{
	playing = false;
}

void musicplayer::play()
{
	playing = true;
}
