/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "moving.h"
#include "world.h"

moving::moving(unsigned int mode) : speed(0), anim_mode(mode), no_moving_command_given(true)
{	
	moving::anim_mode_map[0] = "move_nw";
	moving::anim_mode_map[1] = "move_n";
	moving::anim_mode_map[2] = "move_ne";
	moving::anim_mode_map[3] = "move_w";
	moving::anim_mode_map[4] = "move_e";
	moving::anim_mode_map[5] = "move_sw";
	moving::anim_mode_map[6] = "move_s";
	moving::anim_mode_map[7] = "move_se";
	moving::anim_mode_map[8] = "stand_nw";
	moving::anim_mode_map[9] = "stand_n"; 
	moving::anim_mode_map[10] = "stand_ne";
	moving::anim_mode_map[11] = "stand_w"; 
	moving::anim_mode_map[12] = "stand_e"; 
	moving::anim_mode_map[13] = "stand_sw";
	moving::anim_mode_map[14] = "stand_s"; 
	moving::anim_mode_map[15] = "stand_se";
	moving::anim_mode_map[16] = "paralyse_nw";
	moving::anim_mode_map[17] = "paralyse_n"; 
	moving::anim_mode_map[18] = "paralyse_ne";
	moving::anim_mode_map[19] = "paralyse_w"; 
	moving::anim_mode_map[20] = "paralyse_e"; 
	moving::anim_mode_map[21] = "paralyse_sw";
	moving::anim_mode_map[22] = "paralyse_s"; 
	moving::anim_mode_map[23] = "paralyse_se";
}

int moving::get_move_vector_i(sf::Vector2f pos, std::list<int> disabled_dirs)
{
	sf::Vector2f desired_dir = normalize(mv_pos - pos);
	std::vector<sf::Vector2f> possible_dirs = get_dir_vectors();
	float best = -1000.0f;
	int best_index = -1;

	for(size_t i = 0; i < possible_dirs.size(); i++) {
		std::list<int>::iterator it;
		bool jump_out = false;
		for(it = disabled_dirs.begin(); it != disabled_dirs.end(); it++)
			if (i == (unsigned int) *it)
				jump_out = true; 
		if(jump_out)
			continue;
		//0.2 is the magic number which prevents constant changes in direction
		if(dot(desired_dir, possible_dirs[i]) + ((i == anim_mode) ? 0.2:0) > best) {
			best = dot(desired_dir, possible_dirs[i]);
			best_index = i;
		}
	}
	return best_index;
}

std::pair<bool, sf::Vector2f> moving::move(world &w)
{
	moved = false;
	if(no_moving_command_given)
		return std::make_pair(false, sf::Vector2f());
	if(mv_pos.x == -1.0f && mv_pos.y == -1.0f)
		return std::make_pair(false, sf::Vector2f());
	object *obj = dynamic_cast<object*>(this);
	int move_index = -1;
	int dirs_tried = 0;
	unsigned int prev_anim_mode = anim_mode;
	std::list<int> dis_dirs;
	if(dist(mv_pos, obj->get_pos()) > speed) {
		while(moved == false && dirs_tried < 3) {
			moved = true;
			move_index = get_move_vector_i(obj->get_pos(), dis_dirs);
			sf::Vector2f move_vector = sf::Vector2f(get_dir_vectors()[move_index].x * speed, get_dir_vectors()[move_index].y * speed) ;
			obj->set_pos(obj->get_pos() + move_vector);
			if(w.collision(*obj)) {
				obj->set_pos(obj->get_pos() - move_vector);
				moved = false;
				dis_dirs.push_back(move_index);
			}
			dirs_tried++;
		}
		if(moved)
			anim_mode =	move_index;
	}
	// if previous mode was move and now we don't move anymore then stand	
	if( moved==false && anim_mode < 8) {
		mv_pos = sf::Vector2f(-1.0f, -1.0f);
		anim_mode += 8;
	}
	if(anim_mode != prev_anim_mode)
		obj->set_mode(anim_mode_map[anim_mode]);

	if(!dis_dirs.empty())
		return std::make_pair(moved, get_dir_vectors()[dis_dirs.front()]);
	if(moved == false)
		return std::make_pair(moved, sf::Vector2f());
	return std::make_pair(moved, get_dir_vectors()[anim_mode]);
}

std::vector<sf::Vector2f> moving::get_dir_vectors()
{
	std::vector<sf::Vector2f> dir_vectors;
	for(int y=-1; y<2; y++)
		for(int x=-1; x<2; x++)
			if(x || y)
				dir_vectors.push_back(normalize(sf::Vector2f(x,y)));
	return dir_vectors;
}

