/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _GMAP_H
#define _GMAP_H

#ifndef NO_GRAPHICS
#include <SFML/Graphics.hpp>
#endif
#include <list>
#include "settings.h"
#include "animationloader.h"
#include "object.h"

template<class T> int sgn(T x) {
	if(x > 0)
		return 1;
	else if(x < 0)
		return -1;
	return 0;
}

struct tile {
	enum type {
		grass,
		wall
	} t;

	tile(type _t = grass, int _hp = 100);
	tile(type _t, animation_loader *l, int _hp = 100);
	tile(const tile &);
	~tile();

	void hit(animation_loader *l, int dmg);

	int hp;
	animation *anim;
};

class goal : public object {
	public:
		goal(sf::Vector2i p, animation_loader *anim_loader) 
		{ 
			set_w(128);
			set_h(128);
#ifndef NO_GRAPHICS
			if(anim_loader) {
				anim = new animation(anim_loader->get_animation("goal"));
				anim->set_mode("stand");
			}
#endif
			set_center(sf::Vector2f(p.x * TILE_W, p.y * TILE_H)); 
		}
};

class map {
	public:
		map();
		map(animation_loader *);
		~map();

#ifndef NO_GRAPHICS
		void draw(sf::RenderTarget &r);
		animation *grass;
#endif

		// tiles shouldn't be removed
		std::vector<std::vector<tile> > tiles;

		tile & get_tile(sf::Vector2i coor) { return tiles.at(coor.y).at(coor.x); }

		bool collision(sf::Vector2f pos, float w, float h);
		bool collision(const object &o);

		bool out_of_bounds(sf::Vector2i);

		bool los(sf::Vector2f start, sf::Vector2f end);
		sf::Vector2i coor_to_tile(sf::Vector2f);
		sf::Vector2i nearest_tile(sf::Vector2f, double r, tile::type);
		double dist_to_tile(sf::Vector2f, sf::Vector2i);

		double nearest_next_border(double x, int sign, double w);
		bool near_goal(object *o, double range);

		void update();

		const int w, h;

		static const char *img;
		static const int img_w;
		static const int img_h;

		std::list<goal> goals;
		typedef std::list<goal>::iterator goal_iter;
	private:
		void clear_tiles();
		void load_map();
		animation_loader *anim_loader;

		map(const map &);
		map& operator=(const map &);
};

#endif

