/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include <SFML/System.hpp>
#include <SFML/Graphics.hpp>
#include <SFML/Window.hpp>
#include <iostream>
#include "gui.h"
#include "mainmenu.h"
#include "musicplayer.h"
#include "soundplayer.h"
#include "game.h"
#include "settings.h"
#include "config.h"

void set_volume(soundplayer &, musicplayer &);

int main()
{
	sf::Image icon;
	icon.LoadFromFile("gfx/smallshroom.png");
	sf::RenderWindow app(sf::VideoMode(SCREEN_W, SCREEN_H, 32), "Dimensional Shrooms", sf::Style::Close);
	app.SetIcon(16, 16, icon.GetPixelsPtr());
	main_menu menu;
	Gui::Container *window = menu.window;
	game *g = NULL;
	bool gameon = false;

	soundplayer sound_player;
	musicplayer music_player;

	set_volume(sound_player, music_player);

	music_player.set_playlist("start_menu");

	while(app.IsOpened()) {
		sf::Event event;
		while(app.GetEvent(event)) {
			if(event.Type == sf::Event::Closed) {
				app.Close();
			} else if(event.Type == sf::Event::KeyPressed) {
				if(g && !g->is_paused()) {
					g->KeyDownAction(event.Key);
				} else {
					window->KeyDownAction(event.Key);
				}
			} else if(event.Type == sf::Event::MouseButtonPressed) {
				window->MouseDown(event.MouseButton.X, event.MouseButton.Y, Gui::MouseConv(event.MouseButton.Button));
			} else if(event.Type == sf::Event::MouseButtonReleased) {
				window->MouseUp(event.MouseButton.X, event.MouseButton.Y, Gui::MouseConv(event.MouseButton.Button));
			} else if(event.Type == sf::Event::MouseMoved) {
				window->MouseMotion(event.MouseMove.X, event.MouseMove.Y, app.GetInput());
			} else if(event.Type == sf::Event::TextEntered) {
				window->TextAction(event.Text.Unicode);
			} else if(event.Type == sf::Event::MouseWheelMoved) {
				Gui::Coor k = window->GetMousePos();
				if(event.MouseWheel.Delta > 0) {
					window->MouseDown(k.x, k.y, Gui::BUTTON4);
				} else {
					window->MouseDown(k.x, k.y, Gui::BUTTON5);
				}
			}
		}

		if(gameon) {
			if(g->quit()) {
				delete g;
				g = NULL;
				window = menu.window;
				gameon = false;
				music_player.set_playlist("start_menu");
			}
		} else {
			std::string f;
			if(menu.quit()) {
				app.Close();
			} else if(menu.start_game()) {
//				try {
					g = new game(menu.get_character(), sound_player, music_player);
					gameon = true;
					window = g->window;
//				} catch (...) {
//					g = NULL;
//				}
		//		music_player.set_playlist("ingame");
			} else if((f = menu.replay()).size()) {
				try {
					record rec;
					rec.read(std::string("replays/" + f));

					g = new game(rec.creature_type, sound_player, music_player, true, rec);
					gameon = true;
					window = g->window;

				} catch (rec_exception &r) {
					std::cout << r.what() << std::endl;
					// couldn't read file
					g = NULL;
				} catch (...) {
					g = NULL;
				}
			}
		}

		app.Clear();

		window->HandleLogic();

		if(gameon) {
			g->update();
			g->draw(app);
		}
		music_player.update();
		sound_player.update();
		app.Draw(*window);
		app.Display();
		sf::Sleep(0.01f);
	}
	return 0;
}

void set_volume(soundplayer &sp, musicplayer &mp)
{
	config &conf = config::get();
	double volume = conf.get_value<double>("music_volume");
	int mute = conf.get_value<int>("music_muted");
	if(mute) {
		mp.set_volume(0);
	} else {
		mp.set_volume(volume);
	}

	volume = conf.get_value<double>("sound_volume");
	mute = conf.get_value<int>("sound_muted");
	if(mute) {
		sp.set_volume(0);
	} else {
		sp.set_volume(volume);
	}
}
