/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "laser.h"
#include "object.h"

laser_emitter::laser_emitter(double _len, sf::Vector2f _start, 
		sf::Vector2f _end, double _width)
	: particle_emitter(200.0 / _len), len(_len), start(_start), end(_end), 
		width(_width)
{ 
	set_maximum_age(_len);
	normal = end - start;
	normal = sf::Vector2f(normal.y, -normal.x);
	normal = normalize(normal);
}

particle laser_emitter::create()
{
	sf::Vector2f pos = start + normal * uniform_dist(0, width/2);
	double speed = 200.0f;
	double life = uniform_dist_r(-0.1, 0.1) + dist(start, end) / speed;
	sf::Vector2f vel = normalize(end - start);
	pos += vel * uniform_dist_r(-3, 3);
	vel *= (float)speed;

	sf::Color col = sf::Color(
		uniform_dist_r(180, 255),
		uniform_dist_r(30, 50),
		uniform_dist_r(60, 100)
	);

	return particle(life, col, pos, vel);
}


void laser::shoot(sf::Vector2f start, sf::Vector2f end, particle_engine &e)
{
	laser_emitter *em = new laser_emitter(0.4, start, end, 8);
	particle_group *g = new particle_group(200, em, particle_group::point);

	e.add(g);
}
