/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _EVENT_H
#define _EVENT_H
#include "object.h"
#include "mushroom.h"
#include "trap.h"

class event_handler {
	public:
		virtual ~event_handler() = 0;
		virtual void hit(object *src, object *target, attack &atk) {}
		virtual void grow(mushroom *, mushroom::mushroom_type) {}
		virtual void near_grow(mushroom *, mushroom::mushroom_type) {}
		virtual void die(object *obj) {}
		virtual void spawn(object *obj) {}
		virtual void ding(object *obj) {}
		virtual void win() {}
		virtual void lose() {}
		virtual void wind_blow() {}
		virtual void wind_stop() {}
		virtual void trap_trigger(trap *, ant *a) {}
		virtual void cast_spell(object *caster, const spell &sp) {}
};

inline event_handler::~event_handler() { }

#endif

