/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "dir.h"
#include <iostream>

#ifdef WINDOWS
extern "C" {
#include <windows.h>
}
#else
extern "C" {
#include <dirent.h>
#include <sys/stat.h>
}
#endif

void list_dir(const std::string &dir, std::vector<std::string> &entries)
{
#ifdef WINDOWS
	HANDLE d;
	WIN32_FIND_DATA ent;
	d = FindFirstFile(dir.c_str() ,&ent);
	if(d == INVALID_HANDLE_VALUE)
		return;
	do {
		if(!(ent.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			entries.push_back(std::string(ent.cFileName));
	} while(FindNextFile(d, &ent));
#else
	DIR *d = opendir(dir.c_str());
	if(!d)
		return;
	struct dirent *ent;
	struct stat st;
	while((ent = readdir(d))) {
		if(stat((dir + "/" + ent->d_name).c_str(), &st))
			continue;
		if(ent->d_name[0] != '.' && S_ISREG(st.st_mode))
			entries.push_back(std::string(ent->d_name));
	}
	closedir(d);
#endif
}
