/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef CONFIG_H
#define CONFIG_H

#include <map>
#include <string>
#include <sstream>
#include <fstream>
#include <stdexcept>

class conf_error : public std::logic_error {
	public:
		conf_error(const char *what) : std::logic_error(what) {}
};

class config {
	public:
		typedef std::string key;
		typedef std::string value;

		void write();
		void defaults();
		value &get_string(const key &k);
		void set_string(const key &k, const std::string &);
		int get_value_i(const key &k);
		template<class T> T get_value(const key &k);
		template<class T> void set_value(const key &k, T);
		static config &get();
	private:
		config();
		std::string trim(std::string);
		std::map<key, value> values;
		typedef std::map<key, value>::iterator value_it;
};

template<class T> T config::get_value(const key &k)
{
	std::stringstream ss;
	T v;
	ss.str(get_string(k));
	ss >> v;
	return v;
}

template<class T> void config::set_value(const key &k, T val)
{
	std::stringstream ss;
	ss << val;
	value_it it = values.find(k);
	if(it != values.end())
		values.erase(it);
	values.insert(std::make_pair(k, ss.str()));
	write();
}

#endif

