/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include <iostream>
#include "config.h"
#include "settings.h"

config::config()
{
	std::ifstream in("mushroom.cnf");
	
	std::string line; 
	while(getline(in, line)) {
		size_t p = line.find("=");
		if(p == std::string::npos)
			continue;
		std::string var = trim(line.substr(0, p));
		std::string val = line.substr(p + 1);
		
		values.insert(std::make_pair(var, val));
	}
	defaults();
}

void config::write()
{
	std::ofstream of("mushroom.cnf");
	for(value_it it = values.begin(); it != values.end(); it++) {
		of << it->first << "=" << it->second << std::endl;
	}
}

config::value &config::get_string(const config::key &k)
{
	value_it it = values.find(k);
	if(it == values.end())
		throw conf_error("Can't find key");
	return it->second;
}

std::string config::trim(std::string s)
{
	while(s.size() && s[0] == ' ') {
		s.erase(0);
	}

	while(s.size() && s[s.size() - 1] == ' ') {
		s.erase(s.size() - 1);
	}

	return s;
}

void config::set_string(const key &k, const std::string &str)
{
	value_it it = values.find(k);
	if(it != values.end())
		values.erase(it);
	values.insert(std::make_pair(k, str));
	write();
}

void config::defaults()
{
	int keys[19] = {'q','w','e','r','t','y','u','i','o','p','a','s',
					'd','f','g','h','j','k','l'};
	try {	
		int a = get_value<int>("spell_hotkey_mode");
		if(a != 0 && a != 1)
			throw conf_error("Bad hotkey mode");
	} catch (conf_error &e) {
		set_value<int>("spell_hotkey_mode", 0);
	}

	for(size_t a = 0; a < HOTKEYS; a++) {
		std::stringstream k;
		k << "key" << a;
		try {
			get_value<int>(k.str());
		} catch (conf_error &e)  {
			set_value<int>(k.str(), keys[a]);
		}
	}
	try {	
		get_value<double>("sound_volume");
	} catch (conf_error &e) {
		set_value<double>("sound_volume", 70.0f);
	}	
	try {	
		get_value<double>("music_volume");
	} catch (conf_error &e) {
		set_value<double>("music_volume", 70.0f);

	}	

	try {	
		get_value<int>("music_muted");
	} catch (conf_error &e) {
		set_value<int>("music_muted", 0);
	}	

	try {	
		get_value<int>("sound_muted");
	} catch (conf_error &e) {
		set_value<int>("sound_muted", 0);
	}	

	try {	
		get_string("nick");
	} catch (conf_error &e) {
		set_string("nick", "");
	}
}

config &config::get()
{
	static config cnf;
	return cnf;
}
