/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _COMMAND_CENTER_H
#define _COMMAND_CENTER_H

#include "selectable.h"
#include "animationloader.h"
#include "mushroom.h"
#include <list>

class command_center : public selectable {
	public:
		command_center(animation_loader *l);
	
#ifndef NO_GRAPHICS
		virtual void draw(sf::RenderTarget &);
#endif
		
		const std::list<mushroom*> &get_tree() { return tree; }
		const std::list<mushroom*> &get_connected_mushrooms() { return connected_mushrooms; }
		void tree_fix(world &w);
		void tree_add(mushroom *m, world &w);
		bool tree_rm(mushroom *m);
		void tree_add_rm(mushroom *m, world &w);
		
		void connect_mushroom(mushroom *m);
		void disconnect_mushroom(mushroom *m);
		bool is_connected(mushroom *m);

		bool win_connected(mushroom *m_near_goal, world &w);
		bool win(world &w);

		int mushrooms_growd;
	private:
		std::list<mushroom*> tree;
		std::list<mushroom*> connected_mushrooms;
};

#endif

