/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "butterfly.h"


static inline double sgn(double d)
{
	if(d > 0)
		return 1;
	else
		return -1;
}

butterfly_emitter::butterfly_emitter(animation_loader *l) :
	particle_emitter(1.0), loader(l)
{
	set_maximum_age(99999999);
}

particle butterfly_emitter::create()
{
	sf::Color col(
			uniform_dist(200, 50),
			uniform_dist(220, 25),
			uniform_dist(220, 25));
	double life = uniform_dist(20.0f, 10.0f);
	double x = uniform_dist_r(20.0, SCREEN_W - SIDEBAR_W - 40.0);
	double y = uniform_dist_r(20.0, SCREEN_H - 40.0);
	particle p(life, col, sf::Vector2f(x, y),
				sf::Vector2f(sgn(rand() - RAND_MAX/2) * 20.0, 0));
	p.anim = new animation(loader->get_animation("butterfly"));
	if(p.vel.x < 0) {
		p.anim->set_mode("left");
	} else {
		p.anim->set_mode("right");
	}
	return p;
}

butterfly_group::butterfly_group(butterfly_emitter *e) :
	particle_group(20, e, particle_group::anim) 
{ }

void butterfly_group::move()
{
	std::vector<particle> &p = particles;
	for(size_t i = 0; i < alive; i++) {
		if(rand() < RAND_MAX / 700) {
			p[i].vel = -p[i].vel;
			if(p[i].vel.x < 0) {
				p[i].anim->set_mode("left");
			} else {
				p[i].anim->set_mode("right");
			}
		}
		p[i].pos += DT * p[i].vel;
		p[i].pos += sf::Vector2f(0, DT * 5 * sin(p[i].life));
		if(p[i].max_life - p[i].life < 0.5)
			p[i].col.a = (p[i].max_life - p[i].life) * 255 * 2;
		else if(p[i].life < 0.5)
			p[i].col.a = p[i].life * 255 * 2;
		else
			p[i].col.a = 255;
		p[i].anim->update();
	}
}
