/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _ATTACK_H
#define _ATTACK_H
#include "pauseclock.h"

class attack {
	public:
		enum attack_type {
			ant_attack,
			mushroom_attack,
			tank_attack,
			none_attack
		};

		attack() : type(none_attack), dmg(0), dt(0) { }
		attack(attack_type _type, double _dmg, double _dt) 
			: type(_type), dmg(_dmg), dt(_dt) { }

		attack_type get_type() const { return type; }
		double get_dmg() const { return dmg; }
		void update() { dt -= DT; }
		bool ready() { return dt <= 0; }
		void set_delay(double _dt) { dt = _dt; }
		double get_delay() { return dt; }
	private:
		attack_type type;
		double dmg;
		double dt;
};

class attack_skill {
	public:
		attack_skill(attack::attack_type t);
		void update(bool moved);
		void pause() { timer.pause(); }
		void unpause() { timer.unpause(); }

		attack::attack_type get_type() { return type; }

		bool is_multi() { return multi; }
		bool has_attacked() { return attacked; }

		double get_timer() { return timer.get_time(); }
		double get_reload_time() { return reload_time; }

		void reset_timer() { timer.reset(); }
		bool can_attack();

		attack do_attack();
		double get_range() { return range + range_boost; }

		void set_atk_boost(double b) { atk_boost = b; }
		double get_atk_boost() { return atk_boost; }

		void set_range_boost(double b) { range_boost = b; }
		double get_range_boost() { return range_boost; }
	private:
		pclock timer;
		attack::attack_type type;
		bool multi;

		bool attacked;

		double atk_boost;
		double range_boost;

		double range;
		double dmg;
		double reload_time;
		double delay;
};

#endif
