/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "attack.h"

attack_skill::attack_skill(attack::attack_type t) : 
	type(t), multi(false), attacked(false), atk_boost(0), range_boost(0)
{
	switch(type) {
		case attack::ant_attack:
			dmg = 1.5f;
			reload_time = 2.0f;
			range = 80.0f;
			delay = 0.2f;
			break;
		case attack::mushroom_attack:
			dmg = 30.0f;
			reload_time = 1.5f;
			range = 150.0f;
			delay = 0.8f;
			break;
		case attack::tank_attack:
			dmg = 20.0f;
			reload_time = 3.0f;
			range = 100.0f;
			multi = true;
			delay = 0.2f;
			break;
		case attack::none_attack:
			dmg = 0.0f;
			range = 0;
			delay = 0;
			break;
	}
}

bool attack_skill::can_attack()
{
	return reload_time <= timer.get_time();
}

attack attack_skill::do_attack()
{
	timer.reset();
	attacked = true;
	return attack(type, dmg + atk_boost, delay);
}


void attack_skill::update(bool moved)
{
	timer.step();
	if(moved)
		timer.reset();
}

