/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _ANTHEAP_H
#define _ANTHEAP_H

#include "object.h"
#include "world.h"
#include "settings.h"

class ant_heap : public selectable {
	public:
		ant_heap(animation_loader *l);
		void update(world &w);

		std::string wave_string();
		std::string level_string();
		std::string how_many_string();
		std::string min_time_string();
		std::string max_time_string();
	private:
		struct ant_wave {
			ant_wave(int _times, int _ants, int _levels, double _min_time, double _max_time) : 
				times(_times), ants(_ants), ant_levels(_levels), min_time(_min_time) , 
				max_time(_max_time)
			{ }
			int times;
			int ants;
			int ant_levels;
			double min_time;
			double max_time;
		};

		std::vector<ant_wave> ant_waves;
		std::vector<ant_wave>::iterator cur_wave;
		std::vector<ant_wave>::iterator next_wave;
		int cur_spawned;
		double cur_time;
		double last_spawn;
		int spawned_waves;
};

#endif

