/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _ANT_H
#define _ANT_H

#include "selectable.h"
#include "moving.h"
#include "animationloader.h"
#include "attack.h"

class ant : public selectable, public moving {
	public:
		ant(animation_loader *l, int _level);
		virtual ~ant() {}

		void pause();
		void update(world &w);
#ifndef NO_GRAPHICS
		virtual void draw(sf::RenderTarget &);
#endif
		void has_target(object* tmp_target, world &w);
		void attack_enemy(world &w);
		
		void paralyse(float time);
		bool is_paralysed() { return paralysed; }
		
		void ant_move(world &w);
		sf::Vector2f evade_obstacle_pos(world &w, sf::Vector2f);
		
		std::string level_string();
		int get_level() { return level; }

		bool collision(const object &obj) const;

		void set_target(object *t);
	private:
		attack_skill atk_skill;

		bool paralysed;
		pclock paralyse_timer;
		float paralyse_time;
		
		bool evading_obstacle;
		int evades;

		int level;

		int target_range;
};

#endif

