/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _ANIMATIONLOADER_H
#define _ANIMATIONLOADER_H

#include <stdexcept>
#include "animation.h"

#ifndef NO_GRAPHICS
class animation_loader {
	public:
		animation_loader();
		~animation_loader();

		animation_data& get_animation(std::string name);
	private:
		struct anim_desc;
		void load_animation(anim_desc anim);
		
		std::map<std::string, animation_data*> anims;

		/*
		* Describes one animation
		*/ 
		struct adesc {
			adesc(std::string n, unsigned int l, Uint32 t = 0) 
				: name(n), length(l), chtime(t) 
			{ 
				if(l > 1 && t == 0)
					throw std::invalid_argument("adesc \"" + n + "\": more than one frames but t = 0");
			}
			std::string name;
			unsigned int length;
			Uint32 chtime;
		};

		/*
		* Describes a collection of animations
		*/ 
		struct anim_desc {
			anim_desc(std::string n, std::string f, unsigned int _w, unsigned int _h, 
					bool _dyn = false, sf::Color _dyn_col = sf::Color(0xFF,0,0xFF), 
					sf::Color _dyn_col_range = sf::Color(0,0,0)) 
				: name(n), file(f), w(_w), h(_h), dyn(_dyn), dyn_col(_dyn_col),
					dyn_col_range(_dyn_col_range) { }
			std::string name;
			std::string file;
			unsigned int w, h;
			bool dyn;
			sf::Color dyn_col;
			sf::Color dyn_col_range;
			
			std::vector<adesc> anim_parts;
			anim_desc& add(adesc f) { anim_parts.push_back(f); return *this;}
		};
};

#else


class animation_loader {
	public:
		animation_loader();
		~animation_loader();

		animation_data& get_animation(std::string name) {
			static animation_data d;
			return d;
		}
};

#endif

#endif
