EffectSceneAbstractAnother = Effect:new({num = 300, r = 1, g = 1, b = 1, alpha_max = 1})

function EffectSceneAbstractAnother:setup()
	self.alpha = 0 -- self.alpha_max
	self.w = width()
	self.h = height()
	self.radius = 150
	self.rotation_sign = 1
	self.start_index = 1
	self.point_size = 1
	self.time_multiplier = 2.5
	self.move_random_points = false
	
	self.points = {}
	local s = 200
	for i = 1, self.num, 1 do
		t = math.pi * i * math.random()
		table.insert(self.points, {
			--[[x = s * (0.5 - math.random()),
			y = s * (0.5 - math.random()),
			z = s * (0.5 - math.random())]]--
			x = s * math.sin(t),
			y = 0, --s * math.cos(-t) * math.sin(-t),
			z = s * math.cos(t)
		})
	end
	
	self.camera = { x = 100, y = 0, z = 100, look_x = 0, look_y = 0, look_z = 0, up_x = 0, up_y = 1, up_z = 0, fov = 60, aspect_ratio = width() * 1.0 / height() }
end

function EffectSceneAbstractAnother:update (time)
	local elapsed = time - self.lastTimeUpdated
	local cam = self.camera
	
	local r = self.radius
	
	self.alpha = self.alpha - elapsed
	if self.alpha < 0 then
		self.alpha = 0
	end	
	
	--[[local t = self.rotation_sign * time
	cam.x = r * math.sin(t)
	cam.z = r * math.cos(t)
	cam.y = 100 --r * math.sin(time)]]--
	
	t = time * self.rotation_sign * self.time_multiplier
	if not self.move_random_points then
		cam.x = r * math.sin(t)
		cam.z = r * math.cos(t)

		cam.y = 0.8*r * math.sin(t * 0.45) * math.cos(t * 0.45) -- math.atan(t)
	else
		--cam.x = r -- math.cos(t*16)
		--cam.y = math.atan(t * 4)
		cam.x = cam.x + elapsed*150
		cam.y = cam.y + elapsed*120* self.rotation_sign
		--cam.z = cam.z + 2 * math.sin(t)
		cam.look_x = math.sin(t)
	end
	
	
	camera(
		cam.x, cam.y, cam.z,
		cam.look_x, cam.look_y, cam.look_z,
		cam.up_x, cam.up_y, cam.up_z
	)
	perspective(cam.fov, cam.aspect_ratio, 1, 1000)	
	
	blending(BLENDING_ALPHABLEND)
	--rectangle(self.x, self.y, self.w, self.h)
	
	--drawAxis()
	
	color(self.r, self.g, self.b, self.alpha)
	pointSize(4 * self.alpha)
	--pointSize(self.point_size)
	beginShape(SHAPE_POINTS)
	for i = 1, self.num, 1 do
		local p = self.points[i]
		vertex(p.x, p.y, p.z)
	end
	endShape()
	
	color(self.r, self.g, self.b, self.alpha * 0.4)
	beginShape(SHAPE_LINES)
	
	for i = 1, self.num - 1, 1 do
		local p = self.points[i]
		local q = self.points[i + 1]
		
		if q ~= nil then
			vertex(p.x, p.y, p.z)
			vertex(q.x, q.y, q.z)
		end
	end
	
	
	endShape()
	
	noBlending()

	restoreProjection()

	Effect.update(self, time)	
end

function EffectSceneAbstractAnother:processEvent(event)
	if event.type == EVENT_CHANGE_ROW then
		self.point_size = event.row % 8
		
		if event.row % 8 == 0 and self.move_random_points then
			if math.random() > 0.5 then
				start = 1
			else
				start = 2
			end
			for i = start, #self.points, 2 do
				p = self.points[i]
				p.y = math.random() * self.h * 0.1
			end
		end
		
	elseif event.type == EVENT_CHANGE_ORDER then
		self.rotation_sign = self.rotation_sign * -1
		self.r = math.random() + 0.5
		self.g = math.random() + 0.5
		self.b = math.random() + 0.5
		
		if event.order_position == 12 then
			self.move_random_points = true
		end
	elseif event.type == EVENT_NOTE_ON then
		-- listen to snare
		if event.instrument == 4 then
			self.alpha = self.alpha_max
			self.camera.look_y = self.rotation_sign
		end
		
		-- bd
		if event.instrument == 1 then
			self.camera.x = self.radius * math.random(-1, 1)
			self.camera.y = self.radius * math.random(-1, 1)
			self.camera.z = self.radius * math.random(-1, 1)
			
			self.r = math.random() + 0.5
			self.g = math.random() + 0.5
			self.b = math.random() + 0.5
		end
	end
end
