EffectMetronomic = Effect:new({x = -0.5, y = 0, r = 1, g = 1, b = 0, a = 0.5, energy = 1})

function EffectMetronomic:setup()
	self.x = 0
	self.y = 0
	self.counter = 0
	self.num_divs = 32
	self.half_width = width() * 0.5
	self.half_height = height() * 0.5
	self.div_width = width() * 1.0 / self.num_divs
	--self.x = -self.half_width - self.div_width
end

function EffectMetronomic:update (time)
	local elapsed = time - self.lastTimeUpdated
	local x = self.x
	local y = self.y
	local w = self.div_width
	local h = self.half_height
	
	ortho()
		
	color(self.r, self.g, self.b, self.energy)
	
	self.energy = self.energy - elapsed
	if self.energy < 0 then
		self.energy = 0
	end
	
	blending(BLENDING_ALPHABLEND)
	beginShape(SHAPE_QUADS)
		vertex(x, y - h, 0)
		vertex(x + w, y - h, 0)
		vertex(x + w, y + h, 0)
		vertex(x, y + h, 0)
	endShape()
	noBlending()

	restoreProjection()

	Effect.update(self, time)	
end

function EffectMetronomic:processEvent(event)
	-- listen to 'metronome' instrument only
	if event.instrument == 6 then
		self.energy = self.a
		self.x = -self.half_width + self.counter * self.div_width
		self.counter = (self.counter + 1) % self.num_divs
	end
end
