EffectFlash = Effect:new({r = 1, g = 1, b = 1, alpha_max = 0.15})

function EffectFlash:setup()
	self.alpha = 0 -- self.alpha_max
	self.x = -0.5 * width()
	self.y = -0.5 * height()
	self.w = width()
	self.h = height() 
end

function EffectFlash:update (time)
	local elapsed = time - self.lastTimeUpdated
	
	ortho()
		
	color(self.r, self.g, self.b, self.alpha)
	
	self.alpha = self.alpha - elapsed
	if self.alpha < 0 then
		self.alpha = 0
	end
	
	blending(BLENDING_ALPHABLEND)
	rectangle(self.x, self.y, self.w, self.h)
	noBlending()

	restoreProjection()

	Effect.update(self, time)	
end

function EffectFlash:processEvent(event)
	-- listen to 'hat' instrument only on C-6 note (72)
	if event.instrument == 3 and event.note == 72 then
		self.alpha = self.alpha_max
	end
end
