

-- Base Effect 'class'

Effect = { visible = false}
Effect_mt = { __index = Effect }

function Effect:new(o)
	o = o or { visible = false, lastTimeUpdated = 0 }
	setmetatable(o, self)
	self.__index = self
	return o
end

function Effect:setup()
	-- do nothing here, but do something in children classes!
end

function Effect:show()
	self.visible = true
	--trace("what is self?")
end

function Effect:hide()
	self.visible = false
end

function Effect:update(time)
	-- trace('effect update!')
	self.lastTimeUpdated = time
end

function Effect:processEvent(event)
end
