local tex_ppm, tex_width, tex_height
local beatfade

-- this is done only once, when the demo starts
function salmiak_load() 
--	tex_ppm, tex_width, tex_height = load_texture('ilmari.ppm')

	beatfade = 0
end

local retrig_count = 0

-- done just before first _paint
function salmiak_init(millis)
	--print("salmiak_init "..millis)
	retrig_count = retrig_count + 1
end

local function set_material()
end

local displace = 0
local hitban = 0

-- millis = milliseconds in song
function salmiak_paint(millis, timedelta, params)

	spectrum = engine_spectrum()

	beat = 0
	local beatcount = 50
	for i = 100, 100+beatcount do
		beat = beat + spectrum[i]
	end

	beat = beat / beatcount

	if beat > 0.003 and hitban == 0 then
		retrig_count = retrig_count + 1
		hitban = 1
	end

	if beat < 0.001 then
		hitban = 0
	end

	local glow = math.cos(beat*900)*0.5
	if retrig_count % 2 == 0 then 
		glClearColor(0.8-glow,0.0,0.0,1);
	else
		glClearColor(glow*0.3, glow*0.2, glow*0.2, 1)
	end

        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

	if params.delta then
                millis = time + params.delta
        end

	glDisable(GL_BLEND)
	glDisable(GL_TEXTURE_2D)
	glPushMatrix()
	glEnable(GL_MULTISAMPLE)
		glLoadIdentity()
		glTranslated(0,0,0)
		glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), -100, 100)
		glMatrixMode(GL_MODELVIEW)
--		glTranslated(0,2,3)
--		glScaled(0.2,0.2,0.2)

		local width = glutGet(GLUT_WINDOW_WIDTH)
		local height = glutGet(GLUT_WINDOW_HEIGHT)

		local count = 3+(math.tan(beat*200)*math.cos(millis*0.00003*(300.0*beat))*6)
		--local count = 5

		local s_size = width/count


		displace = displace + timedelta*0.07
		if displace > s_size/1.5 then displace = 0 end

		beatfade = beatfade+beat*100

		if beatfade > 0.99 then beatfade = 0.99 end

		beatfade = beatfade - timedelta*0.005
		local beatfade2 = beatfade
		if beatfade < 0.2 then beatfade2 = 0.0 end

		if beatfade < 0 then beatfade = 0 end

		glTranslated(width/2,height/2, 0)
--		glRotated(100*math.tan(beatfade2*0.008)*math.cos(beatfade2*0.1)*120,math.cos(millis*0.0007)*0.01,math.cos(millis*0.0006+beat*1000)*0.3,1)
		glRotated(100*math.tan(beatfade2*0.008)*math.cos(beatfade2*0.001)*120,0,0,1)
		glTranslated(-width/2,-height/2, 0)

		if retrig_count % 2 == 0 then 
			glColor4d(0,0,0,1)
		else
			glColor4d(0.8,0,0,1)
		end

		for y = -s_size*4, width, s_size do
			for x = -s_size, width+s_size*2, s_size/1.48 do
				glBegin(GL_TRIANGLES)
					as_size = s_size/1.5+math.cos(millis*beat*0.0003)*s_size/3
					local cx = x+displace*1.0*math.tan(x*0.001+millis*0.0001)
					local cy = y+displace*1.5*math.tan(y*0.001+millis*0.0001)
					local cz = -1
					glVertex3d(cx, cy, cz)
					glVertex3d(cx-as_size/3, cy+as_size/2, cz)
					glVertex3d(cx+as_size/3, cy+as_size/2, cz)

					glVertex3d(cx-as_size/3, cy+as_size/2, cz)
					glVertex3d(cx+as_size/3, cy+as_size/2, cz)
					glVertex3d(cx, cy+as_size, cz)
					cx = x-displace*1.0
					cy = cy+math.cos(beatfade*3+millis*0.0001)*s_size*2
					glVertex3d(cx, cy, cz)
					glVertex3d(cx-as_size/3, cy+as_size/2, cz)
					glVertex3d(cx+as_size/3, cy+as_size/2, cz)

					glVertex3d(cx-as_size/3, cy+as_size/2, cz)
					glVertex3d(cx+as_size/3, cy+as_size/2, cz)
					glVertex3d(cx, cy+as_size, cz)
				glEnd();
			end
		end
	glDisable(GL_MULTISAMPLE)
	glPopMatrix()
end

-- called after last _paint
function salmiak_deinit()
	--print("salmiak_deinit")
end

function salmiak_unload()
	--print("salmiak_unload")
end
