local tex_ppm, tex_width, tex_height
local cir_number
local noi_number
local noidata

local not1_number
local not2_number

local effu_start = 0
local pointrot = 0
local noisefactor = 0

-- this is done only once, when the demo starts
function cir_load()
	ppm_num = memarray('uchar', 1)
	tex_ppm, tex_width, tex_height = load_texture('providence.png')
	glGenTextures(1, ppm_num:ptr())
	cir_number = ppm_num[0]
	glBindTexture(GL_TEXTURE_2D, cir_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, tex_width, tex_height, 0, GL_RGB, GL_UNSIGNED_BYTE, tex_ppm:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

	tex2_ppm, tex_width, tex_height = load_texture('nothing1.png')
	glGenTextures(1, ppm_num:ptr())
	not1_number = ppm_num[0]
	glBindTexture(GL_TEXTURE_2D, not1_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, tex_width, tex_height, 0, GL_RGB, GL_UNSIGNED_BYTE, tex2_ppm:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

	tex3_ppm, tex_width, tex_height = load_texture('nothing2.png')
	glGenTextures(1, ppm_num:ptr())
	not2_number = ppm_num[0]
	glBindTexture(GL_TEXTURE_2D, not2_number)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, tex_width, tex_height, 0, GL_RGB, GL_UNSIGNED_BYTE, tex3_ppm:ptr())
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

	glGenTextures(1, ppm_num:ptr())
	noi_number = ppm_num[0]
	noidata = memarray('uchar', 128*128)
end

-- done just before first _paint
function cir_init(millis)
	--print("cir_init "..millis)
	pointrot = 0
	effu_start = millis
	noisefactor = 0
end

local function set_material()                                                                                                                
        glEnable(GL_LIGHT0)
        glLightfv(GL_LIGHT0, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
        glLightfv(GL_LIGHT0, GL_DIFFUSE, {1, 1, 1, 1})
        glLightfv(GL_LIGHT0, GL_POSITION, {0.0, 1.0, 0.0, 0.0})

        glEnable(GL_LIGHT1)
        glLightfv(GL_LIGHT1, GL_AMBIENT, {0.2, 0.2, 0.2, 1})
        glLightfv(GL_LIGHT1, GL_DIFFUSE, {1, 1, 1, 1})
        glLightfv(GL_LIGHT1, GL_POSITION, {1.0, 0.0, 1.0, 0.0})

        glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE)
        glFrontFace(GL_CW)
end

-- millis = milliseconds in song
function cir_paint(millis, timedelta, params)
	for y = 0, 127 do
		for x = 0, 127 do
			noidata[y*128+x] = math.random(0,32)*8
		end
	end

	glBindTexture(GL_TEXTURE_2D, noi_number)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)
        glTexImage2D(GL_TEXTURE_2D, 0, 3, 64, 64, 0, GL_LUMINANCE, GL_UNSIGNED_BYTE, noidata:ptr())

	spectrum = engine_spectrum()

	beat = 0
	local beatcount = 50
	for i = 100, 100+beatcount do
		beat = beat + spectrum[i]
	end

	beat = beat / beatcount

	local boom = beat*10000
	
	glClearColor(0.0,0.0,0.0,1);

        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

	if params.delta then
                millis = time + params.delta
        end

	glPushMatrix()
	glEnable(GL_MULTISAMPLE)
		glLoadIdentity()
		glOrtho(0, glutGet(GLUT_WINDOW_WIDTH), 0, glutGet(GLUT_WINDOW_HEIGHT), -100, 100)
		glMatrixMode(GL_MODELVIEW)

		local width = glutGet(GLUT_WINDOW_WIDTH)
		local height = glutGet(GLUT_WINDOW_HEIGHT)

		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

		local center_offset = height*4

		glEnable(GL_TEXTURE_2D)

		set_material()
		glBindTexture(GL_TEXTURE_2D, cir_number)
		glPushMatrix()
		local boom = beat*20000
		size = boom*2.2+center_offset/17.60
		local camf = math.cos(millis*0.001)*0.2
		glColor3d(0.9+camf,0.8+camf,0.8+camf)
		glTranslated(width/2,height/2,0)
		glRotated(math.sin(millis*0.0002)*360,0,0,1)
		glBegin(GL_QUADS)
			glTexCoord2d(0,0)
			glVertex3d(-size/2,-size/2,-3)
			glTexCoord2d(1,0)
			glVertex3d(size/2,-size/2,-3)
			glTexCoord2d(1,1)
			glVertex3d(size/2,size/2,-3)
			glTexCoord2d(0,1)
			glVertex3d(-size/2,size/2,-3)
		glEnd()
		glDisable(GL_TEXTURE_2D)
		glDisable(GL_BLEND)

		glPopMatrix()
		glLineWidth(2)
		glColor3d(0.4,0.4,0.4)
		


		glPushMatrix()
			glTranslated(width/2,height/2,0)
			glRotated(millis*0.03-boom,0,0,1)
			for i = 0, 128 do
				glRotated((i/128)*360,0,0,0.1)
			glBegin(GL_LINES)
				glVertex2d(width/2+center_offset,height/2)
				glVertex2d(width-center_offset,height/2)
			glEnd()
			end
		glPopMatrix()
		

		glLineWidth(1)
		glColor3d(1,1,1)
		center_offset = height/10
		glPushMatrix()
			glTranslated(width/2,height/2,0)
			glRotated(millis*0.001-boom,0,0,1)
			for i = 0, 256 do
				glRotated((i/256)*360,0,0,0.1)
			glBegin(GL_LINES)
				--glVertex2d(center_offset-math.cos(millis*0.002)*(center_offset/2-beat*20000),0)
				glVertex2d(center_offset+boom,0)
				glVertex2d(height/2-center_offset,0)
			glEnd()
			end
		glPopMatrix()


		glColor3d(0.7,0.7,0.7)
		center_offset = height/5
		pointrot = pointrot + boom*0.05
		glPushMatrix()
			glTranslated(width/2,height/2,0)
			glRotated(-millis*0.01-pointrot,0,0,1)
			for i = 0, 64 do
 			glRotated((i/64)*360,0,0,1)


			pointsize = 6+math.cos(i*0.06+pointrot*0.01)*5;
			glBegin(GL_TRIANGLE_FAN)
			
				glVertex2d(height/4 + center_offset, 0);
			
				for j = 0, 64 do
			
					zin = math.sin(j*(3.14159/32))*pointsize
					coz = math.cos(j*(3.14159/32))*pointsize
	
					glVertex2d(height/4 + center_offset + zin, coz)	
				
				end
			
			glEnd()
			end

		glPopMatrix()
	glPushMatrix()
		tx = 6
		ty = 4

		if millis < 49080 then
		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_ALPHA, GL_ONE)
		glColor4d(0.9,0.9,1,0.1+math.abs(math.sin((millis-effu_start)*0.0003)*1))
		else
		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
		noisefactor = noisefactor + timedelta*0.00013
		glColor4d(noisefactor,noisefactor,noisefactor,noisefactor)

		end

		glEnable(GL_TEXTURE_2D)
		glBindTexture(GL_TEXTURE_2D, noi_number)


		glBegin(GL_QUADS)
			glTexCoord2d(0,0)
			glVertex2d(0,0)
			glTexCoord2d(tx, 0)
			glVertex2d(width,0)
			glTexCoord2d(tx, ty)
			glVertex2d(width, height)
			glTexCoord2d(0, ty)
			glVertex2d(0, height)
		glEnd()

		if noisefactor > 0.6 then
		glBlendFunc(GL_DST_COLOR, GL_ONE_MINUS_SRC_ALPHA)
		glColor4d(1,1,1,0.5)
		nottex = math.random(0,2)
		if nottex == 1 then glBindTexture(GL_TEXTURE_2D, not1_number)
		else glBindTexture(GL_TEXTURE_2D, not2_number)
		end

		notvisib = math.random(1,1000)
		if notvisib % 93 == 1 then 
			glBegin(GL_QUADS)
				glTexCoord2d(0,0)
				glVertex2d(0,0)
				glTexCoord2d(1, 0)
				glVertex2d(width,0)
				glTexCoord2d(1, 1)
				glVertex2d(width, height)
				glTexCoord2d(0, 1)
				glVertex2d(0, height)
			glEnd()
		end
		
		end

	glPopMatrix()

	glDisable(GL_MULTISAMPLE)
	glPopMatrix()
end

-- called after last _paint
function cir_deinit()
	--print("cir_deinit")
end

function cir_unload()
	--print("cir_unload")
end
