/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui>

#include "wigglywidget.h"


WigglyWidget::WigglyWidget(QWidget *parent)
    : QWidget(parent)
{
    QColor aaa = QColor(0, 0, 0);
    QPalette bbb =QPalette(aaa);
    setPalette(bbb);
    setAutoFillBackground(true);

    newFont1 = font();
    newFont1.setPointSize(newFont1.pointSize() + 5);
    setFont(newFont1);

    newFont2 = font();
    newFont2.setPointSize(newFont2.pointSize() + 10);
    setFont(newFont1);

    newFont3 = font();
    newFont3.setPointSize(newFont3.pointSize() + 20);
    setFont(newFont3);

    ShittyModFuck = 1;
    step = 0;
    timer.start(40, this);
    for(int i = 0; i < 20; ++i)
    {
        flyers[i] = new Flyer(rand()%800, rand()%480);
    }

    /*
    QSound *sound=new QSound("test_crap.wav");//getting the audio file
    sound->setLoops(1);
    sound->play();

    */
    mediaObject = new Phonon::MediaObject(this);
    mediaObject->setCurrentSource(Phonon::MediaSource("test_crap.wav"));
    Phonon::AudioOutput *audioOutput =
        new Phonon::AudioOutput(Phonon::MusicCategory, this);
    Phonon::Path path = Phonon::createPath(mediaObject, audioOutput);
    mediaObject->play();
}

void WigglyWidget::paintEvent(QPaintEvent * /* event */)
{


    float time = step/25.f;

    // Exit program
    if(time > 60)
    {
         mediaObject->stop();
        exit(0);

    }
    static const int sineTable[16] = {
        0, 38, 71, 92, 100, 92, 71, 38,	0, -38, -71, -92, -100, -92, -71, -38
    };

    QFontMetrics metrics(font());
    int x = 10;
    int y = (height() - metrics.ascent() - metrics.descent());
    int xcen = width()/2;
    int ycen = height()/2;
    QColor color;
    int beatCount;

    //QSound::play("test_crap.wav");

    //if(soundShit == 0)
  //  if (!QSound::isAvailable())
    {
        //QMessageBox::warning(this, "a", "no sounds");
    }
   // else
    {
        //QMessageBox::warning(this, "a", "sounds yes we have it");
    }

    QPainter painter(this);
    QString textTest =  QString(QDir::currentPath());
   // textTest = pos.loc.coordinate().toString();
    //textTest = pos.loc.coordinate().toString();

    //QContactName conatctName = contact.allContacts.at(6).detail<QContactName>();
    //textTest = conatctName.lastName() + ", " + conatctName.firstName();

    //textTest = textWriter(textTest, time, 0.f, 0.15f);

    //QContactName conatctName = contact.allContacts.at(contact.allContacts.size()/2).detail<QContactName>();
    //textTest = conatctName.lastName() + ", " + conatctName.firstName();
    float alpha = 0.7+(0.3*(step&1));
    color.setRgb(50*alpha, 70*alpha, 65*alpha);
    painter.setPen(color);

    float dt = time / 0.1f;

    // Coordinate
    //textTest = pos.loc.coordinate().toString();
    //textTest = textWriter(textTest, time, 1.0f, 0.12f);
    //painter.drawText(x, y, textTest);


    int count = time / 0.5f;
    if(count < 0) count = 0;
    int max = 10;
    float divider = 1.0f;
    painter.setFont( newFont1);
    //painter.drawText(300, 200, QString::number(time));

    //if(time > 20.0f)
    {
        //static int ShittyModFuck = 1;
        divider = 0.6f;
        max = 20;

        beatCount = (int)(time/divider);

        if((beatCount&7)==0 && ShittyModFuck == 1)
        {
         //   setPalette(QPalette(QColor(120, 120, 120)));
         //   setPalette(QPalette(QColor(120, 120, 120)));
            ShittyModFuck = 0;
        }
        else
        {
            //setPalette(QPalette(QColor(0, 0, 0)));

          //  QPalette PASDADFSPASDFPP = );
          //  setPalette(QPalette(QColor(0, 0, 0)));
            //setPalette(QPalette(QColor(1
            ShittyModFuck = 1;
        }

    }





    srand(beatCount);
    for(int i=0; i<20; i++)
    {
        QContactName VITUTNIMI = contact.allContacts.at(rand() % contact.allContacts.size()).detail<QContactName>();
        int xx = rand()%800 - 100;
        int yy = rand()%460;
        //int yy = (metrics.ascent() + metrics.descent());

        float randiiiii = (rand()%1000)*0.001f;
        color.setRgb(randiiiii*50, randiiiii*60, randiiiii*50);
        painter.setPen(color);

        char buf[255];
        switch(rand()%3)
        {
            case 0:
                painter.setFont(newFont1);
                break;
            case 1:
                painter.setFont(newFont2);
                break;
            case 2:
                painter.setFont(newFont3);
                break;

        }

        QString text = QString("");
        //text = VITUTNIMI;
        text = VITUTNIMI.lastName() + " " + VITUTNIMI.firstName();
        //text = pos.loc.coordinate().toString();
        //sprintf(buf, "%f", time);
        //text.append(buf);
        int offset = 0;
        switch(i&3)
        {
        case 0:
             offset = (step)&0x3f;
             break;
        case 1:
             offset = (-step)&0x3f;
             break;
        case 2:
             offset = (step/2)&0x3f;
             break;
        case 3:
             offset = (-step/2)&0x3f;
             break;
        }
        painter.drawText(xx+offset, yy, text);
    }

    count = 2+time;
    if(count > max) count = max;

    if(time > 54.5f)
    {
        float d = time - 53.f;
        count = max - (d / 0.35f);
        if(count < 0) count = 0;
    }




    float colordt = fmodf(time/divider, 1.0f);
    float ccc = 0.5 + 0.5 * colordt;
    if(time > 20.)
    {
        if((beatCount / 8)&1)
            color.setRgb(131*alpha, 250*alpha, 50*alpha + ccc * 150);
        else
            color.setRgb(231*alpha, 170*alpha, 50*alpha + ccc * 150);
    }
    else
    {
        color.setRgb(231*alpha, 90*alpha, 50*alpha + ccc * 150);
    }

    color.setRgb((color.blue()+rand()%100)&255, color.green(), color.blue());
    painter.setPen(color);

    float lineSpeed = 6-(time/4);
    if(lineSpeed < 1.5f)
        lineSpeed = 1.5f;
    float beat2222 = (time/lineSpeed) / divider;
    float beatTime = fmodf(beat2222, 1.0f);
    for(int i = 0; i < count; i++)
    {
        int shortest = 100000;

        if(!((beatCount+2)&3) && time > 20.)
        {
            flyers[i]->size = 2 + 100 * beatTime;
        }
        else
        {
            flyers[i]->size = 10;
        }
        flyers[i]->setTime(beat2222, (int)(time*10.0f) / (divider * 10));
        flyers[i]->draw(painter);
        for(int j = 0; j < 3; j++)
        {
            if(j != i)
            {
                int xdiff = flyers[i]->x - flyers[j]->x;
                int ydiff = flyers[i]->y - flyers[j]->y;

                float crapshitfuck = xdiff*xdiff+ydiff*ydiff;
                if(crapshitfuck < 0.0001f)
                {
                    crapshitfuck = 0.0001f;
                }
                float len = sqrtf(crapshitfuck);
                if( len < shortest )
                {
                    shortest = len;
                    flyers[i]->nearest = j;
                }
            }
        }
    }
    for(int i = 0; i < count; i++)
    {
        painter.drawLine(QPoint(flyers[i]->x, flyers[i]->y), QPoint(flyers[flyers[i]->nearest]->x, flyers[flyers[i]->nearest]->y));
        painter.drawLine(QPoint(flyers[i]->x+1, flyers[i]->y), QPoint(flyers[flyers[i]->nearest]->x+1, flyers[flyers[i]->nearest]->y));
        painter.drawLine(QPoint(flyers[i]->x, flyers[i]->y+1), QPoint(flyers[flyers[i]->nearest]->x+1, flyers[flyers[i]->nearest]->y+1));
    }


}

void WigglyWidget::timerEvent(QTimerEvent *event)
{
    if (event->timerId() == timer.timerId()) {
        ++step;
        update();
    } else {
	QWidget::timerEvent(event);
    }

}
