module SceneBlock3 (b3_rawscenes) where

import Util

left = (-3)
right = 3
down = (-3)
up = 3

-------------------------------------------------------------------------------
-- Block 3: Some actual information

-- Seinaareja / Kompoja
b3t1times = (21500,24400)
b3t1begin   = calcBegin b3t1times
b3t1stable  = calcStable b3t1times 
b3t1fadeout = calcFadeout b3t1times
b3t1end     = calcEnd b3t1times

uppery = 0.2
lowery = (-0.1)
b3t1a_path = Path (TP (pnt left uppery) b3t1begin) (TP (pnt (-0.1) uppery) b3t1stable) (TP (pnt (0.1) uppery) b3t1fadeout) (TP (pnt right uppery) b3t1end)
b3t1a = LoadMarquee "Seminaareja" 0.8 b3t1a_path
b3t1b_path = Path (TP (pnt right lowery) b3t1begin) (TP (pnt (0.1) lowery) b3t1stable) (TP (pnt (-0.1) lowery) b3t1fadeout) (TP (pnt left lowery) b3t1end)
b3t1b = LoadMarquee "Kompoja" 1.6 b3t1b_path

b3t2times = (24400,27700)
b3t2begin   = calcBegin b3t2times
b3t2stable  = calcStable b3t2times 
b3t2fadeout = calcFadeout b3t2times
b3t2end     = calcEnd b3t2times

ohjelm_h = 0.2
b3t2a_path = Path (TP (pnt left ohjelm_h) b3t2begin) (TP (pnt (-0.1) ohjelm_h) b3t2stable) (TP (pnt (0.1) ohjelm_h) b3t2fadeout) (TP (pnt right ohjelm_h) b3t2end)
b3t2a = LoadMarquee "Ohjelmoitava" 1.6 b3t2a_path
salitekn_h = (-0.1)
b3t2b_path = Path (TP (pnt right salitekn_h) b3t2begin) (TP (pnt (0.1) salitekn_h) b3t2stable) (TP (pnt (0.1) salitekn_h) b3t2fadeout) (TP (pnt left salitekn_h) b3t2end)
b3t2b = LoadMarquee "salivalaistus!" 1.1 b3t2b_path

screen12s = [b3t1a, b3t1b, b3t2a, b3t2b]

-- Muun muassa: [erilaisia kisoja]

-- Common header
b3t3_mm_path = Path (TP (pnt 0 up) 27700) (TP (pnt 0 0.5) 28000) (TP (pnt 0 0.5) 38600) (TP (pnt 0 up) 39000)
b3t3_mm = LoadMarquee "Kompot:" 0.7 b3t3_mm_path

sizes = 1.0

h_upper = 0.15
h_lower = (-0.15)

b3t3_1_times = (28000,33500)
b3t3_1_begin   = calcBegin b3t3_1_times
b3t3_1_stable  = calcStable b3t3_1_times 
b3t3_1_fadeout = calcFadeout b3t3_1_times
b3t3_1_end     = calcEnd b3t3_1_times

b3t3_demo_path = Path (TP (pnt left h_upper) b3t3_1_begin) (TP (pnt (-0.1) h_upper) b3t3_1_stable) (TP (pnt 0.0 h_upper) b3t3_1_fadeout) (TP (pnt right h_upper) b3t3_1_end)
b3t3_demo = LoadMarquee "demokompo" (sizes+0.4) b3t3_demo_path
b3t3_summam_path = Path (TP (pnt right h_lower) b3t3_1_begin) (TP (pnt 0.15 h_lower) b3t3_1_stable) (TP (pnt (-0.15) h_lower) b3t3_1_fadeout) (TP (pnt left h_lower) b3t3_1_end)
b3t3_summam = LoadMarquee "summamutikka" sizes b3t3_summam_path

b3t3_2_times = (33100,36800)
b3t3_2_begin   = calcBegin b3t3_2_times
b3t3_2_stable  = calcStable b3t3_2_times 
b3t3_2_fadeout = calcFadeout b3t3_2_times
b3t3_2_end     = calcEnd b3t3_2_times

b3t3_levyke_path = Path (TP (pnt left h_upper) b3t3_2_begin) (TP (pnt (-0.05) h_upper) b3t3_2_stable) (TP (pnt 0.0 h_upper) b3t3_2_fadeout) (TP (pnt right h_upper) b3t3_2_end)
b3t3_levyke = LoadMarquee "levykkeenheitto" sizes b3t3_levyke_path
b3t3_sinko_path = Path (TP (pnt right h_lower) b3t3_2_begin) (TP (pnt 0.1 h_lower) b3t3_2_stable) (TP (pnt (-0.05) h_lower) b3t3_2_fadeout) (TP (pnt left h_lower) b3t3_2_end)
b3t3_sinko = LoadMarquee "sinkohippa" (sizes+0.5) b3t3_sinko_path

b3t3_3_times = (36400,39000)
b3t3_3_begin   = calcBegin b3t3_3_times
b3t3_3_stable  = calcStable b3t3_3_times 
b3t3_3_fadeout = calcFadeout b3t3_3_times
b3t3_3_end     = calcEnd b3t3_3_times

b3t3_fmus_path = Path (TP (pnt left h_upper) b3t3_3_begin) (TP (pnt 0.07 h_upper) b3t3_3_stable) (TP (pnt 0.15 h_upper) b3t3_3_fadeout) (TP (pnt right h_upper) b3t3_3_end)
b3t3_fmus = LoadMarquee "vikkelähkö musiikki" (sizes+0.5) b3t3_fmus_path
b3t3_fgfx_path = Path (TP (pnt right h_lower) b3t3_3_begin) (TP (pnt 0.15 h_lower) b3t3_3_stable) (TP (pnt 0.07 h_lower) b3t3_3_fadeout) (TP (pnt left h_lower) b3t3_3_end)
b3t3_fgfx = LoadMarquee "vikkelähkö grafiikka" (sizes+0.5) b3t3_fgfx_path

screen3s = [b3t3_demo, b3t3_summam, b3t3_mm, b3t3_levyke, b3t3_sinko, b3t3_fmus, b3t3_fgfx]

b3_rawscenes :: [RawScene]
b3_rawscenes = concat [screen12s, screen3s]
