module Display (display,idle) where
import Graphics.Rendering.OpenGL hiding (Front)
import Graphics.UI.GLUT hiding (Front,Font)
import Data.IORef
import Control.Monad.State hiding (get)
import Graphics.Rendering.FTGL
import Scenes
import Fonts
import Util

-- Living with Floats/GLfloats.. dunno how.
hirvio :: Float -> GLfloat
hirvio f = fromRational (toRational f)

-- Draws 1 line
drawLine :: Fontset -> MappedLine -> Float -> (MappedLine -> Point) -> (MappedLine -> Point) -> IO ()
drawLine fonts line ratio get1 get2 = do
    translate (Vector3 (hirvio x) (hirvio y) (hirvio z) :: Vector3 GLfloat)
    scale 0.006 0.006 (0.006::GLfloat)
    setFontFaceSize (stdfont fonts) (fsize line) 10
    renderFont (stdfont fonts) (text line) Front
  where
    x = (px (get1 line)) + (ratio*((px (get2 line))-(px (get1 line))))
    y = (py (get1 line)) + (ratio*((py (get2 line))-(py (get1 line))))
    z = (pz (get1 line)) + (ratio*((pz (get2 line))-(pz (get1 line))))

drawBothLines :: Fontset -> Scene -> Float -> (MappedLine -> Point) -> (MappedLine -> Point) -> IO ()
drawBothLines fonts scene ratio get1 get2 = do
  foldl (>>) (return ()) $ map (\t->(drawLine fonts t ratio get1 get2)>>loadIdentity) (texts scene)

calcRatio :: Millis -> Millis -> Millis -> Float
calcRatio at' start' end' = (at-start)/(end-start)
  where
    at    = fromIntegral at'
    start = fromIntegral start'
    end   = fromIntegral end'

drawScene :: Scene -> Millis -> Fontset -> IO ()
drawScene scene ms fonts
  | ms >= begin scene && ms < stable scene   = drawBothLines fonts scene (calcRatio ms (begin scene) (stable scene)) p1 p2
  | ms >= stable scene && ms < fadeout scene = drawBothLines fonts scene (calcRatio ms (stable scene) (fadeout scene)) p2 p3
  | ms >= fadeout scene && ms < end scene    = drawBothLines fonts scene (calcRatio ms (fadeout scene) (end scene)) p3 p4
  | otherwise                                = return ()

display :: IORef Int -> Fontset -> IO ()
display millis fonts = do 
  clear [ColorBuffer]
  ms <- liftIO $ get millis
  foldl (>>) (return ()) $ map (\x->drawScene x ms fonts) scenes
  loadIdentity
  swapBuffers

idle millis = do
  aika <- (get elapsedTime)
  millis $= aika+0
  postRedisplay Nothing
