function init(w, h)
   print("Lua: Init called with args " .. w .. ", " .. h)
   width = w
   height = h
end

-- C function reference:
-- setpixel(x, y, i) sets a grayscale pixel with intensity i
-- setpixel(x, y, i, r, g, b) sets an RGB pixel
-- cleartexture() clears the entire texture

function render(time_in_millis)
   phase = 2 * math.pi * time_in_millis / 1000
   cleartexture()
   setpixel((1 + 0.8 * math.sin(phase)) * height / 2, 
            (1 + 0.8 * math.cos(phase)) * height / 2, 255)
end

