      SUBROUTINE ITERATIONS(X, Y, ITER, MAXITER, CUTOFF)
      COMPLEX*8 C, Z
      REAL*8 X, Y, CUTOFF
      INTEGER MAXITER, ITER
      ITER = 0
      Z = 0
      C = CMPLX(X, Y)
      DO WHILE (ABS(Z) < CUTOFF .AND. ITER < MAXITER)
         Z = Z**2 + C
         ITER = ITER + 1
      END DO
      RETURN
      END

      SUBROUTINE MANDEL(ARR, W, H, X0, Y0, X1, Y1, MAXITER, CUTOFF)
      INTEGER W, H
      INTEGER I, J
      INTEGER MAXITER
      INTEGER ARR(W, H)
      REAL*8 DX, DY
      REAL*8 X0, Y0, X1, Y1
      REAL*8 X, Y
      REAL*8 CUTOFF
      INTEGER ITERCOUNT
      DX = (X1-X0)/W
      DY = (Y1-Y0)/H
      DO I = 1, W
         X = X0 + (I-1)*DX
         DO J = 1, H
            Y = Y0 + (J-1)*DX
            ITERCOUNT = 0
            CALL ITERATIONS(X, Y, ITERCOUNT, MAXITER, CUTOFF)
            ARR(I, J) = ITERCOUNT
         END DO
      END DO
      RETURN
      END 
