with Ada.Text_IO, Ada.Integer_Text_IO, Ada.Command_Line;
use Ada.Text_IO, Ada.Integer_Text_IO, Ada.Command_Line;

procedure AltDemo is

   type Palette is array(INTEGER range 0..15,
                         INTEGER range 0..15) of INTEGER;
   Table : Palette;
   Temp  : Palette;
   Num_Wraps : INTEGER;

   procedure Shift_Palette(Pal : in out Palette) is
   begin
      for J in 0..15 loop
         for I in 0..15 loop
            Temp(J, I) := Pal((J+15) mod 16, (I+15) mod 16);
         end loop;
      end loop;

      for J in 0..15 loop
         for I in 0..15 loop
            Pal(J, I) := Temp(J, I);
         end loop;
      end loop;

   end Shift_Palette;

   procedure Clear_Table(T : out Palette) is
   begin
      for J in 0..15 loop
         for I in 0..15 loop
            T(J, I) := J*16 + I;
         end loop;
      end loop;
   end Clear_Table;

   procedure Print_Table(T : in Palette) is
   begin
      for J in 0..15 loop
         for I in 0..15 loop
            Put(T(J, I));
            New_Line;
         end loop;
      end loop;
   end Print_Table;

begin

   Num_Wraps := Integer'Value(Ada.Command_Line.Argument(1));
   Clear_Table(Table);
   for I in 1..Num_Wraps loop
      Shift_Palette(Table);
   end loop;
   Print_Table(Table);

end AltDemo;

