#include "colors.inc"
#include "glass.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"

#if (clock <= 0.25)
  #declare clock1 = 4*clock;
    camera {
    right x*1.778
    location <0, 13-10*sin(clock1*pi/2), 0>
    look_at <0, 3, 20>
  }
#else
  #if (clock <= 0.5)
    #declare clock2 = 4*(clock-0.25);
    camera {
      right x*1.778
      location <0, 3, 0>
      look_at <0, 3, 20>
    }
  #else
    #if (clock < 0.75)
      #declare clock3 = 4*(clock-0.5);
      camera {
        right x*1.778
        location < clock3*-20, 3 + 2*clock3, 0>
        #if (clock3 < 0.3)
          look_at <-40*sin(clock3*3*pi/2), 3, 20*cos(clock3*3*pi/2)>
        #else
          look_at<-40, 3, 0>
        #end
      }
    #else
      #declare clock4 = 4*(clock-0.75);
      camera {
        right x*1.778
        location <-20, 5, 0>
        look_at<-40, 3, 0>
      }
    #end
  #end
#end

background {color Cyan}

light_source {
  <-10, 0, 20>
  color White
}

light_source {
  <-30, 0, 5>
  color White
}

#if (clock < 0.75)
/* Spot 1 */
light_source {
  <5, 5, -6>
  color Red
  spotlight
  radius 30
  falloff 30
  tightness 10
  point_at <-1 + 2*sin(clock*4*2*pi), 0, 6 + 2*cos(clock*4*2*pi)>
}


/* Spot 2 */
light_source {
  <-5, 5, -6>
  color Yellow
  spotlight
  radius 20
  falloff 10
  tightness 15
  point_at <1 + 2*sin(clock*4*2*pi), 0, 6 - 2*cos(clock*4*2*pi)>
}
#end

#if (clock > 0.75)
/* The End spot */
light_source {
  <-46, 20, 10 - 80*(1-clock)>
  color White
  spotlight
  radius 40
  falloff 10
  tightness 15
  point_at <-40, 6, 0>
}
#end

plane { <0, 1, 0> 0
  pigment {
    checker color Blue, color White
  }
}

/* Reflecting ball */
sphere { <-2, 4, 15>, 4
  texture { Copper_Metal }
}

/* Lens */
intersection{
  sphere{<0,0,0>,6  translate <0,0,-5.9>}
  sphere{<0,0,0>,6  translate <0,0, 5.9>}
  scale<1.2 1 1.5>
  texture{ T_Glass3 }
  interior{ I_Glass }
  translate < 1, 2, 7>
}

/* Pedestal */
box {
  <0.5, 0, 6.5>
  <1.5, 1.0, 7.5>
  texture { T_Grnt20 }
}

/* Donut */
torus {
  6, 5
  rotate z*-90
  translate <-20, 5, 0>
  texture { T_Stone29 }
}

/* Rolling ball */

sphere { <0, 0, 0> , 3
  texture{ T_Wood14 }
  rotate <0, 0, -3*clock*360>
  translate <-pi, 3, 11>
  translate <6*2*pi*clock-12, 0, 0>
}

/* The End */

/* T */

box {
  <-41, 5, -8>
  <-40, 6, -3>
  texture {T_Stone24}
  translate<0, 6, 0>
}
box {
  <-41, 1, -6>
  <-40, 5, -5>
  texture {T_Stone24}
  translate<0, 6, 0>
}

/* H */

box {
  <-41, 1, -2>
  <-40, 6, -1>
  texture {T_Stone24}
  translate<0, 6, 0>
}
box {
  <-41, 1, 1>
  <-40, 6, 2>
  texture {T_Stone24}
  translate<0, 6, 0>
}
box {
  <-41, 3, -1>
  <-40, 4, 1>
  texture {T_Stone24}
  translate<0, 6, 0>
}

/* E */

box {
  <-41, 1, 3>
  <-40, 2, 7>
  texture {T_Stone24}
  translate<0, 6, 0>
}
box {
  <-41, 3, 3>
  <-40, 4, 6>
  texture {T_Stone24}
  translate<0, 6, 0>
}
box {
  <-41, 5, 3>
  <-40, 6, 7>
  texture {T_Stone24}
  translate<0, 6, 0>
}

/* E */
box {
  <-41, 1, 4>
  <-40, 2, 8>
  texture {T_Stone24}
  translate<0, 0, -11>
}
box {
  <-41, 3, 4>
  <-40, 4, 7>
  texture {T_Stone24}
  translate<0, 0, -11>
}
box {
  <-41, 5, 4>
  <-40, 6, 8>
  texture {T_Stone24}
  translate<0, 0, -11>
}

/* N */

box {
  <-41, 1, -2>
  <-40, 6, -1>
  texture {T_Stone24}
}
box {
  <-41, 1, 2>
  <-40, 6, 1>
  texture {T_Stone24}
}
box {
  <-41, 3, -1>
  <-40, 5, 0>
  texture {T_Stone24}
}
box {
  <-41, 2, 0>
  <-40, 4, 1>
  texture {T_Stone24}
}

/* D */

box {
  <-41, 1, 3>
  <-40, 6, 4>
  texture {T_Stone24}
}
box {
  <-41, 1, 4>
  <-40, 2, 6>
  texture {T_Stone24}
}
box {
  <-41, 5, 4>
  <-40, 6, 6>
  texture {T_Stone24}
}
box {
  <-41, 2, 6>
  <-40, 5, 7>
  texture {T_Stone24}
}

