//=========================================================================
START	EQU	#6200	;25088
//=========================================================================
	DEVICE	ZXSPECTRUM128
	ORG	START
	DS	65536-START,0	;clear ram
//-------------------
	ORG	START
	LD	SP,START
	JP	SETUP
//----------------------- DEPACK LOADED BLOCKS
LOADER	DI
	PUSH	IY
	LD	HL,LOADTBL
LDTBLA	EQU	$-2
	LD	A,(HL)
	INC	HL
	LD	BC,#7FFD
	OUT	(C),A
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	LD	(LDTBLA),HL
	LD	H,B
	LD	L,C
	CALL	DEPACK
	POP	IY
	RET
//------
;	 :
;	1) loader #START (size=LOADER_END-#START)
;	2) #LOADER_END..#7FFF (PAGE#15)
;	3) PAGE #10 C000
;	4) PAGE #17 DB00
;	5) PAGE	#13 C000
;	6) PAGE #11 C000
;	7) #8000 (PAGE#12)
//------
;	2-6    #8000    
;	7 -    #C000  14      8000
//------
LOADTBL	;[1]PAGE [2]OUTADR [2]INADR
	//---		#61XX..#7FFF (PAGE#15)
	DB	#15	
	DW	LOADER_END
	DW	#8000
	//---		PAGE #10, #C000
	DB	#10	
	DW	#C000
	DW	#8000
	//---		PAGE #11, #C000
	DB	#11	
	DW	#C000
	DW	#8000
	//---		PAGE #13, #C000
	DB	#13	
	DW	#C000
	DW	#8000
	//---		PAGE #17, #DB00
	DB	#17	
	DW	#DB00
	DW	#8000
	//---		PAGE #14, #8000
	DB	#14	
	DW	#8000
	DW	#C000
//------
DEPACK	INCLUDE "depacker.asm"
LOADER_END
//-----------------------
	INCLUDE	"music/ay/player.asm"
//----------------------- variables
;SCR1SP,SCR2SP -    
;SCR1C,SCR2C - -    1
;	STBL1,STBL2 -  
;	+0 call out_adr (#XX00 / #XX80 -  )
;	+2 scr adr
;	+4 dw $
;	+6 dw ret1/ret2/ret3/ret4
;	(32  1  ,  704 )
COVOX		EQU	#FB
WAVTBL		EQU	#7E00
TEXTBUFF	EQU	#7E18	;TEXTBUFF_END-264
TEXTBUFF_END	EQU	#7F00+32
L_TBL		EQU	#7F00+33

TSIN2		EQU	#9E00
TSIN4		EQU	#9F00

;IM2TBL		EQU	#BE00 (512)	
MUSFLAG		EQU	#BFBF+2
IM2PAGE		EQU	#BFBF+#1F

BRGB5		EQU	#43
BRGB7		EQU	#41

//========================================== SCROLL (3437) [HL` 3]
SCROLL ;    3437+448=3885t
//(20+17   = 187 +448 free) ~639t
	//--->0
	LD	(SOHRSP5),SP	;20
	LD	HL,#D800+768-32 ;10
TRGBADR	EQU	$-2
	LD	SP,HL		;6
	LD	DE,#0707	;10 /46
	//--->46
	DUP	16
	PUSH	DE	;11 /176
	EDUP
	//--->222
	LD	A,H	;4
	SUB	#80	;7
	LD	H,A	;4
	LD	SP,HL	;6
	LD	DE,0	;10 /31
	//--->253
	DUP	11
	PUSH	DE	;11 /121
	EDUP
	//--->374
	EXX		  ;4
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11
	EXX		  ;4 /32 (443  )[1]
	//--->406
	DUP	5
	PUSH	DE	;11 /55
	EDUP
	//--->461--- 1  
	LD	DE,#8000+32	;10
	ADD	HL,DE		;11
	LD	SP,HL		;6
	LD	DE,#4747	;10 /37	
	//--->498 (121free)
	DUP	11
	PUSH	DE	;11 /121
	EDUP
	//--->619
	EXX		;4
	OUT	(C),D	;12
	EXX		;4  /20 //->639
	//-----------------------   (224*3=672)
	// 663   (664  )
	DUP	5
	PUSH	DE	;11 /55
	EDUP
	//--->55 (283covox)
	LD	A,H	;4
	ADD	A,#80	;7
	LD	H,A	;4
	LD	SP,HL	;6
	LD	DE,0	;10 /31
	//--->86 (369)
	DUP	4
	PUSH	DE	;11 /44
	EDUP
	//--->130 (413)
	EXX		  ;4
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11
	EXX		  ;4 /32 (445 )[2]
	//--->162 
	DUP	12
	PUSH	DE	;11 /132
	EDUP
	//--->294
	LD	SP,0	;10
SOHRSP5	EQU	$-2
	//--->308
	LD	A,21	;pause 311
	DEC	A
	JP	NZ,$-1	
	LD	DE,0	/294+7+10
	//--->619
	EXX		  ;4
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11 [3]
	OUT	(C),E	  ;12
	EXX		  ;4 /44 //->663
	//---------------------------------------------  (1792)
	//------    
		;(    64 )
	LD	A,0		;7
TMVCNT	EQU	$-1
	OR	A		;4
	JP	Z,NOTMV		;10 /21
	//--->21
TMOVOK	DEC	A		;4
	LD	(TMVCNT),A	;13 
	LD	(SOHRSP6),SP	;20
	LD	HL,#8004	;10
MCADR	EQU	$-2
	LD	SP,TEX1A	;10
MTADR	EQU	$-2
	LD	BC,3		;10 /67
	//--->88
	EXX		;4
	LD	A,#19	;7
	OUT	(C),A	;12
	EXX		;4 /27
	//--->115
	LD	A,5 ;7
TMV1	POP	DE	;10
	LD	(HL),D	;7
	INC	L	;4
	LD	(HL),E	;7
	ADD	HL,BC	;11
	DEC	A	;4
	JP	NZ,TMV1	;10 /53*6+7=272 (5  16)
	//--->387
	EXX		  ;4
	OUT	(C),E	  ;12
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11
	LD	A,#19	  ;7
	OUT	(C),A	  ;12
	EXX		  ;4 /63
	//--->450
	LD	A,7 ;7
TMV2	POP	DE	;10
	LD	(HL),D	;7
	INC	L	;4
	LD	(HL),E	;7
	ADD	HL,BC	;11
	DEC	A	;4
	JP	NZ,TMV2	;10 /53*7+7=378 (12  16)
	//--->828
	NOP	;4
	//--->832
	EXX		  ;4
	OUT	(C),E	  ;12
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11
	LD	A,#19	  ;7
	OUT	(C),A	  ;12
	EXX		  ;4 /63
	//--->895
	LD	A,4 ;7
TMV3	POP	DE	;10
	LD	(HL),D	;7
	INC	L	;4
	LD	(HL),E	;7
	ADD	HL,BC	;11
	DEC	A	;4
	JP	NZ,TMV3	;10 /53*4+7=219 (16  16)
	//--->1114
	EXX		;4
	OUT	(C),E	;12
	EXX		;4 /20
	//--->1134
	LD	(MTADR),SP	;20
	LD	HL,MCADR+1	;10
	INC	(HL)		;11
	LD	SP,0		;10 /51
SOHRSP6	EQU	$-2
TMVEND	//--->1185
	LD	A,7	;7 --- pause115
	DEC	A
	JP	NZ,$-1	;14*7=98
	JP	$+3	;10 //115
	//--->1300
	EXX		  ;4
	OUT	(C),E	  ;12
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11
	EXX		  ;4 //44
	//--->1344

	//--->
	//pause408
	LD	A,28	;7
	DEC	A
	JP	NZ,$-1	;14*28=392
	LD	A,R	;9 //408
	//---
	EXX		  ;4
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11
	OUT	(C),D	  ;12 /40 //--->1792
	//---------------------------------------------   (224*3=672)
	LD	A,9	;pause_145
	DEC	A
	JP	NZ,$-1	//133
	NOP
	NOP
	NOP		///145
	//---  scr2out ( )
	EXX				;4
SCR2OUT LD	IX,STBL2A		;10
SCR2SP	EQU	$-2
	LD	A,0			;7
SCR2C	EQU	$-1
	OR	A			;4
	JP	Z,NOSCR2OUT		;10 /35
	LD	C,A			;4
	LD	(IX+6),low RET1X	;19
	LD	(IX+7),high RET1X	;19
	LD	(XSP1),SP		;20
	LD	SP,(SCR2SP)		;20
	POP	HL			;10
	JP	(HL)			;6 //129 (+382) ///511
RET1X	//---
	EXX		;4
	OUT	(C),E	;12 /16 ///=527
	//----------------- 
	LD	A,6
	DEC	A
	JP	NZ,$-1 //161
	EXX				;4
	LD	(IX+6),low RET1		;19
	LD	(IX+7),high RET1	;19
	JP	RET1			;10 /52
	//---------------------------------
NOSCR2OUT ;    35+145
	//--- pause 476
	LD	A,33
	LD	A,33
	DEC	A
	JP	NZ,$-1 //462
	//---
	EXX		;4
	OUT	(C),E	;12 /16
	//---
	EXX		;4
	RET		;10 
	//-----------------
NOTMV ;   ,   1491-21
	//---21
	LD	A,27	;7
	DEC	A
	JP	NZ,$-1	;14*27=378
	LD	DE,0	;10 /395
	//---416
	EXX		  ;4
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11
	EXX		  ;4 /32
	//---448
	LD	A,29	;7
	DEC	A
	JP	NZ,$-1	;14*29=406
	NOP		;4 /417
	//---865
	EXX		  ;4
	LD	A,(HL)	  ;7
	INC	HL	  ;6
	OUT	(COVOX),A ;11
	EXX		  ;4 /32
	//---897
	LD	A,18	;7 pause278
	DEC	A
	JP	NZ,$-1	;14*18=252
	LD	A,0	;7
	NOP		;4
	NOP		;4
	NOP		;4 //278
	//---1175
	JP	TMVEND	;10 //-->1185
//==========================================913
REGRID	LD	(SOHRSP2),SP	;20
	//---
	LD	BC,#0F0F	;10
	LD	HL,(TSCRADR)	;16
	INC	H		;4
	INC	H		;4
	LD	E,L		;4 //62 + 376+87+372+14
	//---
	LD	SP,HL	;6
	PUSH	BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC ;11*16=176
	LD	L,E	;4
	INC	H	;4	#D7E0
	LD	SP,HL	;6
	PUSH	BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC ;11*16=176
	LD	L,E	;4 //376
	//---	
	;LD	A,H	;7
	;SUB	7	;7
	;LD	H,A	;7
	DEC	HL	;6
	INC	H
	LD	A,L	;4	
	ADD	A,#20	;7
	LD	L,A	;4
	JR	C,RG2	;10 /52
	LD	A,H	;4
	SUB	8	;7
	LD	H,A	;4
	JP	RG1	;10 /25
RG2	POP	BC	;10
	PUSH	BC	;11
	NOP		;4 /25`
RG1	INC	HL	;6 
	LD	E,L	;4 /10 //87
	//---
	LD	SP,HL	;6
	PUSH	BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC ;11*16=176
	LD	L,E	;4
	INC	H
	INC	H
	LD	SP,HL
	PUSH	BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC ;11*16=176
	LD	L,E	;4
	INC	H	;4
	LD	SP,HL	;6
	PUSH	BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC,BC ;11*16=176
	//---		; //372
XXX	LD	SP,0	;10
SOHRSP2	EQU	$-2
	RET		;10 /20
//========================================== CALC_FX (6474) [BC`,22]
;      
CALCFX1	EXX			;4
	LD	HL,STBL1A+1+8*87	;10
SCR1SPF	EQU	$-2
	LD	DE,0-8		;10
	EXX			;4
	LD	A,(SCR1C)	;13
	LD	C,#80		;+7
	JP	$+3		;10 /51
	//---
	LD	B,A
	LD	D,TSIN2/256	;7	//104 , 10 
	LD	H,TSIN4/256	;7	//342*22=6248 ///6474
	LD	L,0		;7
E1V1	EQU	$-1
	LD	E,0		;7
E1V2	EQU	$-1
	OR	A		;4
	JP	Z,EXITRET	;10 /53-7
	//---
CFX1	DUP	4
	LD	A,(DE)		;7
	INC	E		;4
	ADD	A,(HL)		;7
	INC	L		;4
	ADD	A,C		;4
	EXX			;4
	LD	(HL),A		;7
	ADD	HL,DE		;11
	EXX			;4 /52*4=208
	EDUP
	//---
	LD	A,E		;4
	ADD	A,1//1		;7
E1V1S	EQU	$-1
	LD	E,A		;4
	LD	A,L		;4
	ADD	A,2//2		;7
E1V2S	EQU	$-1
	LD	L,A		;4 /30
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//---
	DEC	B		;4
	JP	NZ,CFX1		;10 /14 //284  (6248  22 )
	//---
	RET			;10
//-----------------------------------
CALCFX2	EXX			;4
	LD	HL,STBL2A+1	;10
SCR2SPF	EQU	$-2
	LD	DE,8		;10
	EXX			;4
	LD	A,(SCR2C)	;13
	LD	C,#A0		;+7
	JP	$+3		;10 /51
	//---
	LD	B,A
	LD	D,TSIN2/256	;7	//104 , 10 
	LD	H,TSIN4/256	;7	//342*22=6248 ///6474
	LD	L,0		;7
E2V1	EQU	$-1
	LD	E,0		;7
E2V2	EQU	$-1
	OR	A		;4
	JP	Z,EXITRET	;10 /53-7
	//---
CFX2	DUP	4
	LD	A,(DE)		;7
	INC	E		;4
	ADD	A,(HL)		;7
	INC	L		;4
	ADD	A,C		;4
	EXX			;4
	LD	(HL),A		;7
	ADD	HL,DE		;11
	EXX			;4 /52*4=208
	EDUP
	//---
	LD	A,E		;4
	ADD	A,2//1		;7
E2V1S	EQU	$-1
	LD	E,A		;4
	LD	A,L		;4
	ADD	A,1//2		;7
E2V2S	EQU	$-1
	LD	L,A		;4 /30
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//---
	DEC	B		;4
	JP	NZ,CFX2		;10 /14 //284  (6248  22 )
	//---
EXITRET	RET			;10
//=========================================== SCROUT
;SCR2OUT LD	(XSP1),SP	;20
;	LD	SP,STBL2A	;10
;SCR2SP	EQU	$-2
;	LD	C,0		;7
;SCR2C	EQU	$-1
;	EXX			;4
;	LD	BC,#7FFD	;10
;	LD	DE,#171F	;10
;	EXX			;4
;	JP	STEST		;10  /93-init, 20-ret
	//-----
SCR1OUT	LD	(XSP1),SP	;20
	LD	SP,STBL1A	;10
SCR1SP	EQU	$-2
	LD	C,22		;7
SCR1C	EQU	$-1
	EXX			;4
	LD	BC,#7FFD	;10
	LD	DE,#171F	;10
	EXX			;4
	//-----
STEST	LD	A,C		;4
	OR	A		;4
	JP	Z,RETSP1	;10 /18 //83-init, 20-ret
SLOOP	;   
	//------------------------- line 0
	NOP		;4
	NOP		;4 /8
	POP	HL		;10
	JP	(HL)		;4 /14(+382) 396
	//---
RET1	EXX			;4
	LD	A,(HL)		;7
	INC	HL		;6
	OUT	(COVOX),A	;11
	OUT	(C),D		;12
	EXX			;4 /44 //448
	//------------------------- line 1
	NOP		;4
	DEC	HL	;6 /10
	POP	HL		;10
	JP	(HL)		;4 /14(+382) 396
	//---
RET2	EXX			;4
	LD	A,(HL)		;7
	INC	HL		;6
	OUT	(COVOX),A	;11
	OUT	(C),E		;12
	EXX			;4 /44 //450
	//------------------------- line 2
	POP	HL		;10
	JP	(HL)		;4 /14(+382) 396
	//---
RET3	EXX			;4
	LD	A,(HL)		;7
	INC	HL		;6
	OUT	(COVOX),A	;11
	OUT	(C),D		;12
	EXX			;4 /44 //440
	//------------------------- line 3
	POP	HL		;10
	JP	(HL)		;4 /14(+382) 396
	//---
RET4	EXX			;4
	LD	A,(HL)		;7
	INC	HL		;6
	OUT	(COVOX),A	;11
	OUT	(C),E		;12
	EXX			;4 /44 //440
	//------- y_line counter
	DEC	C		;4
	JP	NZ,SLOOP	;10 /14
	//----	
RETSP1	LD	SP,0	;10
XSP1	EQU	$-2
	RET		;10 /20

//==================================================   (4794) [BC` 8]
TEXTOUT	LD	(SOHRSP3),SP		;20
	LD	HL,TEXTBUFF_END-1	;10
	LD	DE,#D4E0		;10 //40
TSCRADR	EQU	$-2
	//---
	EX	DE,HL	;4
	LD	SP,HL	;6
	EX	DE,HL	;4 /14
	//--- 4
	DUP	4
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//-
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//-
	DUP	3
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//----
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	HL	;6
	DEC	L	;4
	PUSH	BC	;11 /72
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//---
	INC	D	;4
	EX	DE,HL	;4
	LD	SP,HL	;6
	EX	DE,HL	;4 /18	
	//--- 5
	DUP	4
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//-
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//-
	DUP	3
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//----
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	HL	;6
	DEC	L	;4
	PUSH	BC	;11 /72
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//---
	INC	D	;4
	EX	DE,HL	;4
	LD	SP,HL	;6
	EX	DE,HL	;4 /18	
	//--- 6
	DUP	4
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//-
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//-
	DUP	3
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//----
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	HL	;6
	DEC	L	;4
	PUSH	BC	;11 /72
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//---
	INC	D	;4
	EX	DE,HL	;4
	LD	SP,HL	;6
	EX	DE,HL	;4 /18	
	//--- 7
	DUP	4
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//-
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//-
	DUP	3
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//----
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	HL	;6
	DEC	L	;4
	PUSH	BC	;11 /72
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32 //2332 -  
	//----------------
	DEC	DE	;6
	INC	D	;4
	LD	A,E	;4	
	ADD	A,#20	;7
	LD	E,A	;4
	JR	C,TO2	;10 /29
	LD	A,D	;4
	SUB	8	;7
	LD	D,A	;4
	JP	TO1	;10 /25
TO2	POP	BC	;10
	PUSH	BC	;11
	NOP		;4 /25
TO1	INC	DE	;6 /6 //70
	//---------------
	EX	DE,HL	;4
	LD	SP,HL	;6
	EX	DE,HL	;4 /14	
	//--- 0
	DUP	4
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//-
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//-
	DUP	3
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//----
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	HL	;6
	DEC	L	;4
	PUSH	BC	;11
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//---
	INC	D	;4
	EX	DE,HL	;4
	LD	SP,HL	;6
	EX	DE,HL	;4	
	//--- 1
	DUP	4
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//-
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//-
	DUP	3
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//----
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	HL	;6
	DEC	L	;4
	PUSH	BC	;11
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//---
	INC	D	;4
	EX	DE,HL	;4
	LD	SP,HL	;6
	EX	DE,HL	;4	
	//--- 2
	DUP	4
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//-
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//-
	DUP	3
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//----
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	HL	;6
	DEC	L	;4
	PUSH	BC	;11
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//---
	INC	D	;4
	EX	DE,HL	;4
	LD	SP,HL	;6
	EX	DE,HL	;4	
	//--- 3
	DUP	4
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//-
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32
	//-
	DUP	3
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11 /66*7=462
	EDUP
	//----
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	DEC	L	;4
	PUSH	BC	;11
	LD	B,(HL)	;7
	DEC	L	;4
	LD	C,(HL)	;7
	PUSH	BC	;11
	//---
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4 /32 //2396
	//---
	LD	SP,0	;10
SOHRSP3	EQU	$-2
	RET		;10 //20
//================================================ TEXT_SCROLL (5726) [BC`,22]
TEXT_SCROLL 	;   
	EXX			;4
	LD	HL,TEXTBUFF_END	;10 /14
	//---
	DUP	11
	//---
	RL	(HL)		;15
	DEC	HL		;6
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4 /78
	//---
	RL	(HL)		;15
	DEC	HL		;6
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4 /78
	//---
	RL	(HL)		;15
	DEC	HL		;6
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4 /78
	//---
	LD	A,(BC)		;7
	INC	BC		;7
	OUT	(COVOX),A	;11 /25
	//---
	RL	(HL)		;15
	DEC	HL		;6
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4 /78
	//---
	RL	(HL)		;15
	DEC	HL		;6
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4 /78
	//---
	RL	(HL)		;15
	DEC	HL		;6
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4
	RL	(HL)		;15
	DEC	L		;4 /78
	//---
	LD	A,(BC)		;7
	INC	BC		;7
	OUT	(COVOX),A	;11 /25 //518*11=5698
	//---
	EDUP
	//---
	EXX			;4
	RET			;10 /14
//=========================================================
TEXSYM	EXX			;4 //456
	LD	A,8		;7
TFLAG	EQU	$-1		;-
	DEC	A		;4
	LD	(TFLAG),A	;13
	JP	NZ,TEXT0	;10 /38
	//---
	LD	A,8		;7
	LD	(TFLAG),A	;13
	LD	HL,TEXT		;10
TEXADR	EQU	$-2		;-
	LD	A,(HL)		;7
	OR	A		;4
	JP	Z,TEXTCYC	;10
	LD	DE,0		;10
	LD	DE,0		;10
TEXT1	LD	A,(HL)		;7
	ADD	A,0		;7
NFONTADD EQU	$-1		;-
	LD	E,A		;4
	LD	D,FONT/256	;7
	LD	A,(DE)		;7
	INC	D		;4
	LD	(NFONTADD),A 	;13
	LD	A,(DE)		;7
	INC	D		;4
	ADD	A,L		;4
	LD	L,A		;4
	ADC	A,H		;4
	SUB	L		;4
	LD	H,A		;4
	LD	(TEXADR),HL 	;16
	LD	BC,0-33		;10
	LD	HL,TEXTBUFF_END ;10 /187
	//---
	DUP	7
	LD	A,(DE)		;7
	INC	D		;4
	LD	(HL),A		;7
	ADD	HL,BC		;11 /29*7=203
	EDUP
	LD	A,(DE)		;7
	LD	(HL),A		;7 /14 //217
	//---
	JP	TEXT_E		;10 /10	//
TEXT0	//--- pause 400	
	LD	A,26	;7
	DEC	A	;-
	JP	NZ,$-1	;14*26=364	
	LD	HL,0	;10
	LD	A,R	;9
	JP	TEXT_E	;10 //400
TEXTCYC //--   
	LD	HL,TEXT		;10
	JP	TEXT1		;10	
TEXT_E	//---
	EXX	;4
	RET
//------------------------------------------------------ 
SLINECALC ;     (23  0..22)
; 2 SCR1SPFX
; 2 SCR2SP
; 2 TRGBADR
; 2 TSCRADR // 6 * 23 = 138 
; 2 SCR1SP -  
; 2 SCR1size,SCR2size / 
	LD	A,22
LINE	EQU	$-1
	LD	(SCR1C),A
	LD	L,A
	LD	A,22
	SUB	L
	LD	(SCR2C),A
	LD	A,L
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,low L_TBL
	LD	L,A
	LD	H,L_TBL/256

	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(SCR1AF),DE
	EX	DE,HL
	LD	BC,704
	ADD	HL,BC
	EX	DE,HL
	LD	(SCR1BF),DE

	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(SCR2SPA),DE
	EX	DE,HL
	LD	BC,704
	ADD	HL,BC
	EX	DE,HL
	LD	(SCR2SPB),DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(TRGBADR),DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(TSCRADR),DE
	RET
//=================================================== DIGIPLAYER
DIGIPLAYER ;  HL -  
	//---------- process curr wav
	LD	A,#80
WAVFLAG	EQU	$-1
	CP	#80
	JP	Z,DPN
	LD	(WAVADR),HL
DP3	LD	A,(HL)	
	CP	#80
	JP	NZ,DPN
	LD	(WAVFLAG),A
	LD	HL,WAV0
	LD	(WAVADR),HL
	//---------- next position
DPN	LD	A,1		;7
WAVC	EQU	$-1
	DEC	A		;4
	LD	(WAVC),A	;13
	RET	NZ		;??
	//---   
	LD	A,6		;7
	LD	(WAVC),A	;13
	LD	HL,WAVTRK2	;10
TRACKADR EQU	$-2
DP0	LD	A,(HL)		;7
	CP	#FF		;7
	JP	NZ,DP2		;10 -  
	LD	HL,WAVPATT+2
PATTADR	EQU	$-2
	LD	A,(HL)
	CP	#FF
	JP	NZ,DP4
	LD	HL,WAVPATT
DP4	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(PATTADR),HL
	EX	DE,HL
//	LD	HL,WAVTRACK1	;10
	LD	A,(HL)		;7
DP2	INC	HL		;6
	LD	(TRACKADR),HL	;16
	LD	(WAVFLAG),A	;13
	LD	H,WAVTBL/256	;7
	LD	L,A		;4
	LD	E,(HL)		;7
	INC	L		;4
	LD	D,(HL)		;7
	LD	(WAVADR),DE	;20
	RET			;10
//==================================
FXTRACKER
	LD	A,3
TCNT	EQU	$-1
	DEC	A
	LD	(TCNT),A
	RET	NZ
	LD	A,3
	LD	(TCNT),A
	//---
	LD	A,0
TIMER	EQU	$-1
	INC	A
	LD	(TIMER),A
	LD	C,A
	//---
	LD	HL,FXTRACK
FTRKADR	EQU	$-2
	LD	A,(HL)
	CP	#FF
	JP	NZ,FXT1
	LD	HL,FXTRACK
	LD	A,(HL)
FXT1	CP	C
	RET	NZ
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(FTRKADR),HL
	EX	DE,HL
	JP	(HL)
//---------------------------
FXTRACKFUCK
//---------------------------
SETVAR_UP
	EX	DE,HL
	LD	A,(HL)
	INC	HL
	LD	(E1V1S),A
	LD	A,(HL)
	INC	HL
	LD	(E1V2S),A
	LD	(FTRKADR),HL
	RET
SETVAR_DW
	EX	DE,HL
	LD	A,(HL)
	INC	HL
	LD	(E2V1S),A
	LD	A,(HL)
	INC	HL
	LD	(E2V2S),A
	LD	(FTRKADR),HL
	RET
FX_M_UP ;---    
	LD	A,LNTBLSZ
	LD	(LMVCNT),A
	LD	HL,LNTBL2
	LD	(LMVTBL),HL
	RET
FX_M_DW	;---    
	LD	A,LNTBLSZ
	LD	(LMVCNT),A
	LD	HL,LNTBL1
	LD	(LMVTBL),HL
	RET
FX_TEXMOV ;------  
	EX	DE,HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(MTADR),DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(MCADR),DE
	LD	A,30
	LD	(TMVCNT),A
	LD	(FTRKADR),HL
	RET
//===================================
PROCESSFX
	LD	BC,#7FFD
	LD	A,#13
	OUT	(C),A
	//---
	LD	A,0
LMVCNT	EQU	$-1
	OR	A
	JP	Z,NOLMV
	DEC	A
	LD	(LMVCNT),A
	LD	HL,0
LMVTBL	EQU	$-2
	LD	A,(HL)
	LD	(LINE),A
	INC	HL
	LD	(LMVTBL),HL
NOLMV	//---
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	RET
//==========================================================================================
//									MAIN LOOP
//==========================================================================================
MAINLP	EI
	HALT
	XOR	A
	OUT	(#FE),A
	//--
	LD	BC,#7FFD	;10
	LD	A,#17		;7
	OUT	(C),A		;12 /29
	//--
	EXX			;4
	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	EXX			;4
	//-------------   
	CALL	TEXT_SCROLL	;17+5726t=5743 [BC`,22]
	//-------------   
	CALL	TEXTOUT ;4788+256=5044 [BC`,16]
	//-------------      
	CALL	CALCFX1	;17	[BC`,22]
	CALL	CALCFX2	;17	//2*17+6474=6510t
	//------------- change wav adr bc`->hl`
	EXX		;4
	LD	H,B	;4
	LD	L,C	;4
	EXX		;4 //16

	LD	BC,#7FFD
	LD	A,#17+#08
	OUT	(C),A
//-----------------------------
//    17920-448-83-17=17372  (17374   - )
//---------------------   [HL`,88 -  ]
	CALL	SCR1OUT ;17+83-init,20-ret
	CALL	SCROLL	;3584-17-20-(17+93)=3437     ret
	//CALL	SCR2OUT ;17+93-init,20-ret -   scroll
	//-------------     
	EXX
	PUSH	HL
	//-------------  
	CALL	REGRID	;17+913
	//------------- process FX track
	CALL	FXTRACKER
	CALL	PROCESSFX
	//-------------      
	CALL	SLINECALC ;17
	//-------------   
	LD	A,0
FLIP	EQU	$-1
	XOR	#FF
	LD	(FLIP),A
	JP	NZ,FLIP1
	LD	HL,(SCR1SPA)
	LD	(SCR1SP),HL
	LD	HL,(SCR1AF)
	LD	(SCR1SPF),HL
	LD	HL,(SCR2SPA)
	LD	(SCR2SP),HL
	INC	HL
	LD	(SCR2SPF),HL
	JP	FLIP0
FLIP1	LD	HL,(SCR1SPB)
	LD	(SCR1SP),HL
	LD	HL,(SCR1BF)
	LD	(SCR1SPF),HL
	LD	HL,(SCR2SPB)
	LD	(SCR2SP),HL
	INC	HL
	LD	(SCR2SPF),HL	

FLIP0	//---
	//---------------------- Process effect 1
	LD	A,0
E1V1X	EQU	$-1
	ADD	A,0-1	;0-1	//-1	;1
E1V1STP	EQU	$-1
	LD	(E1V1X),A
	ADD	A,0
E1V1COR	EQU	$-1
	LD	(E1V1),A
	LD	A,0
E1V2X	EQU	$-1
	ADD	A,0+1	;//1	;3
E1V2STP	EQU	$-1
	LD	(E1V2X),A
	ADD	A,0
E1V2COR	EQU	$-1
	LD	(E1V2),A
	//---------------------- Process effect 2
	LD	A,0
E2V1X	EQU	$-1
	ADD	A,0-1	;0-1	//-1	;1
	LD	(E2V1X),A
	LD	(E2V1),A
	LD	A,0
E2V2X	EQU	$-1
	ADD	A,0+1	;//1	;3
	LD	(E2V2X),A
	LD	(E2V2),A
	//--------------------    
	LD	BC,#7FFD
	LD	A,#13
	OUT	(C),A
	CALL	TEXSYM
	//--------------------  AY 
	LD	A,#10
	LD	BC,#7FFD
	OUT	(C),A
	CALL	AYPLAY
	LD	A,#17
	LD	BC,#7FFD
	OUT	(C),A
	//--------------------  Digital 
	POP	HL
	CALL	DIGIPLAYER
	LD	BC,WAV0
WAVADR	EQU	$-2
	LD	E,55
WAVXX	LD	A,(BC)		;7
	INC	BC		;6
	OUT	(COVOX),A	;11
	DEC	E		;4
	DUP	8
	LD	HL,0		;10*8
	EDUP
	//---
	JP	NZ,WAVXX	;10 /188 //6490
	EXX
	JP	MAINLP
//==========================================================================================
//									INIT SECTION
//==========================================================================================
INIT2	LD	A,#10
	CALL	PAGER
	EI
	HALT
	XOR	A
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),A
	LDIR
	
	CALL	INI_CODE
	LD	A,#17
	CALL	PAGER

	LD	HL,#D800
	LD	DE,#D801
	LD	BC,767
	LD	(HL),7+7*8
	LDIR

	CALL	GRID
	CALL	INI_TEXTURE
	//--- 
PLOOP	EI
	HALT
	LD	A,165-96+2+18
PAUSE1	EQU	$-1
	DEC	A
	LD	(PAUSE1),A
	JP	NZ,PLOOP
	//---  
	LD	A,#17
	CALL	PAGER
	LD	HL,WAV0
	CALL	DIGIPLAYER
	//---
I2L3	EI
	HALT
	LD	BC,#7FFD
	LD	HL,(WAVADR)
	LD	A,H
	SUB	high WAV1
	LD	H,A
	LD	A,L
	AND	%11111110
	SUB	low WAV1
	OR	H
	LD	E,#17
	LD	A,0
	JP	NZ,BLINK1
	LD	E,#17+#08
	LD	A,7
BLINK1	OUT	(#FE),A
	OUT	(C),E
	//------
	LD	HL,(WAVADR)
	LD	B,150
I2L1	LD	A,(HL)		;7
	INC	HL		;6
	OUT	(COVOX),A	;11
	LD	A,25		;4
	DEC	A
	JP	NZ,$-1	;14*20=280
	DEC	B		;4
	JP	NZ,I2L1		;10 /42
	CALL	DIGIPLAYER
	LD	A,96-1-2
I2L2	EQU	$-1
	DEC	A
	LD	(I2L2),A
	JP	NZ,I2L3

	LD	LX,2
BLINK	EI
	HALT
	LD	A,7
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),7+7*8
	LDIR
	DEC	LX
	JP	NZ,BLINK

	//---     
	LD	A,#C9
	LD	(#BFBF),A
	LD	HL,WAVTRACK1
	LD	(TRACKADR),HL
	LD	A,1
	LD	(WAVC),A
	LD	BC,WAV0
	EXX
	JP	MAINLP
//---
PAGER	LD	BC,#7FFD
	LD	(IM2PAGE),A
	OUT	(C),A
	RET
//--------------------
FUCK_SIN
	LD	HL,TSIN2
	CALL	FS0
	LD	HL,TSIN4
FS0	LD	B,0
FS1	LD	A,(HL)
	ADD	A,7
	LD	(HL),A
	INC	HL
	DJNZ	FS1
	RET
//-------------------------------------- init out tables
INI_OTBL ;  
;	STBL1,STBL2 -  
;	+0 call out_adr (#XX00 / #XX80 -  )
;	+2 scr adr
;	+4 dw $
;	+6 dw ret1/ret2/ret3/ret4
;	(32  1  ,  704 )
;-------
	LD	HL,STBL1A
	LD	DE,#5820
	LD	HY,#00
	LD	LY,22
	CALL	IO0
	LD	HL,STBL2A
	LD	DE,#5860
	LD	HY,#00
	LD	LY,22
	CALL	IO0
	LD	HL,STBL1B
	LD	DE,#5820
	LD	HY,#80
	LD	LY,22
	CALL	IO0
	LD	HL,STBL2B
	LD	DE,#5860
	LD	HY,#80
	LD	LY,22
IO0	LD	IX,RET1
	CALL	IO1
	//-
	LD	A,D
	ADD	A,#80
	LD	D,A
	LD	IX,RET2
	CALL	IO1
	//-
	LD	A,D
	SUB	#80
	LD	D,A
	LD	IX,RET3
	CALL	IO1
	//-
	LD	A,D
	ADD	A,#80
	LD	D,A
	LD	IX,RET4
	CALL	IO1
	//-
	LD	A,D
	SUB	#80
	LD	D,A
	PUSH	HL
	LD	HL,#20
	ADD	HL,DE
	LD	D,H
	LD	E,L
	POP	HL
	//-
	DEC	LY
	JP	NZ,IO0
	RET
IO1	LD	A,HY
	LD	(HL),A
	INC	HL
	LD	(HL),0
	INC	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	LD	B,H
	LD	C,L
	INC	BC
	INC	BC
	LD	(HL),C
	INC	HL
	LD	(HL),B
	INC	HL
	PUSH	IX
	POP	BC
	LD	(HL),C
	INC	HL
	LD	(HL),B
	INC	HL
	RET
//-------------------------------------- init LTBL
; 2 SCR1SP
; 2 SCR2SP
; 2 TRGBADR
; 2 TSCRADR // 6 * 23 = 138 
INI_LTBL
	LD	BC,L_TBL
	LD	DE,STBL1A+1-8
	LD	HL,STBL2A
	LD	IX,#D820
	LD	IY,#C400
	LD	A,23
ILL1	EX	AF,AF
	LD	A,E
	LD	(BC),A
	INC	C
	LD	A,D
	LD	(BC),A
	INC	C
	LD	A,L
	LD	(BC),A
	INC	C
	LD	A,H
	LD	(BC),A
	INC	C
	LD	A,LX
	LD	(BC),A
	INC	C
	LD	A,HX
	LD	(BC),A
	INC	C
	PUSH	IY
	PUSH	BC
	LD	BC,#20
	ADD	IY,BC
	POP	BC
	LD	A,LY
	LD	(BC),A
	INC	C
	LD	A,HY
	LD	(BC),A
	INC	C
	POP	IY
	//---
	PUSH	BC
	LD	BC,#20
	ADD	IX,BC
	LD	A,LY
	ADD	A,#20	//1F
	LD	LY,A	
	JP	NC,ILL0	
	LD	A,HY
	ADD	A,8
	LD	HY,A
ILL0	//INC	IY
	LD	BC,32
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	POP	BC
	EX	AF,AF
	DEC	A
	JP	NZ,ILL1
	RET
//-------------------------------------- init #8000 code
INI_CODE ;     #8000
;	POP	HL	;10
;	POP	DE	;10
;	LD	SP,HL	;6 /26
;	DUP	16
;	LD	HL,#0000	;10
;	PUSH	HL		;11 /336
;	EDUP
;	EX	DE,HL	;4
;	LD	SP,HL	;6
;	RET		;10 /20 //382 (70 )
;-------
	LD	H,#80
	LD	C,30
IC2	LD	L,0
	CALL	IC0
	LD	L,#80
	CALL	IC0
	INC	H
	DEC	C
	JP	NZ,IC2
	//---
	LD	H,#A0
	LD	C,30
IC3	LD	L,0
	CALL	IC0
	LD	L,#80
	CALL	IC0
	INC	H
	DEC	C
	JP	NZ,IC3
	RET
IC0	LD	(HL),#E1	;pop hl
	INC	L
	LD	(HL),#D1	;pop de
	INC	L
	LD	(HL),#F9	;ld sp,hl
	INC	L
	LD	B,16
IC1	LD	(HL),#21	;ld hl,nn
	INC	L
	LD	(HL),1+2*8	;#00	;n
	INC	L
	LD	(HL),3+4*8	;#00	;n
	INC	L
	LD	(HL),#E5	;push hl
	INC	L
	DJNZ	IC1
	LD	(HL),#EB	;ex de,hl
	INC	L	
	LD	(HL),#F9	;ld sp,hl
	INC	L
	LD	(HL),#C9	;ret
	RET
//-------------------------------------- draw scr grid
GRID	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,6143
	LD	(HL),#0F
	LDIR
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR
	RET
//-------------------------------------- move texture1
INI_TEXTURE
	LD	A,#11
	CALL	PAGER
	//---
	LD	DE,TEX1A
	LD	HL,#8000+5
	CALL	IT
	LD	DE,TEX1B
	LD	HL,#8080+5
	CALL	IT
	LD	DE,TEX2A
	LD	HL,#A000+5
	CALL	IT
	LD	DE,TEX2B
	LD	HL,#A080+5
IT	LD	C,30
IT0	LD	B,16
	PUSH	HL
IT1	LD	A,(DE)
	INC	DE
	LD	(HL),A
	DEC	L
	LD	A,(DE)
	INC	DE
	LD	(HL),A
	INC	L
	INC	L
	INC	L
	INC	L
	INC	L
	DJNZ	IT1
	POP	HL
	INC	H
	DEC	C
	JP	NZ,IT0
	RET
//---------------------------------------------
STBL1A	DS	704,0
STBL1B	DS	704,0
STBL2A	DS	704,0
STBL2B	DS	704,0
//---------------------------------------------
END_6000
//---------------------------------------------
	ORG	TSIN2
	INCBIN	"cos14_2.tbl"
	ORG	TSIN4
	INCBIN	"cos14_4.tbl"
	ORG	WAVTBL
	DW	WAV0,WAV1,WAV2,WAV3
XPAGE	DB	0
SCR1AF	DW	STBL1A+1+87*8
SCR1BF	DW	STBL1B+1+87*8
SCR1SPA	DW	STBL1A
SCR1SPB	DW	STBL1B
SCR2SPA	DW	STBL2A+32*20
SCR2SPB	DW	STBL2B+32*20
// 3 byte free
//=======================================================================
// #BE00..#BFFF SECTION: INTERRUPT ROUTINE AND SOME PROCEDURES AND VARS
//=======================================================================
	ORG	#BE00
	DS	258,#BF
	ORG	#BF02
//------ init im2
IM2INI	DI
	LD	A,#BE	;    INT
	LD	I,A
	IM	2
	EI
	RET
//------ FXTRACK TABLE
FXTRACK	DB	0
	DW	FX_M_UP
	DB	128
	DW	FX_TEXMOV
	DW	TEX3A
	DW	#8004
	DB	128+32
	DW	FX_TEXMOV
	DW	TEX3B
	DW	#8084
	//---
	DB	0
	DW	FX_M_DW
	DB	128
	DW	FX_TEXMOV
	DW	TEX4A
	DW	#A004
	DB	128+32
	DW	FX_TEXMOV
	DW	TEX4B
	DW	#A084
	//---
	DB	0
	DW	FX_M_UP
	DB	128
	DW	FX_TEXMOV
	DW	TEX5A
	DW	#8004
	DB	128+32
	DW	FX_TEXMOV
	DW	TEX5B
	DW	#8084
	DB	128+33
	DW	SETVAR_UP
	DB	0-1,0-1
	//---
	DB	0
	DW	FX_M_DW
	DB	128
	DW	FX_TEXMOV
	DW	TEX13A
	DW	#A004
	DB	128+32
	DW	FX_TEXMOV
	DW	TEX10A	//10A
	DW	#A084
	//---
	DB	0
	DW	FX_M_UP
	DB	128
	DW	FX_TEXMOV
	DW	TEX2A	//2A
	DW	#8004
	DB	128+32
	DW	FX_TEXMOV
	DW	TEX2X
	DW	#8084
	DB	128+33
	DW	SETVAR_UP
	DB	2,1	//1,2
	//---
	DB	0
	DW	FX_M_DW
	DB	128
	DW	FX_TEXMOV
	DW	TEX9A
	DW	#A004
	DB	128+32
	DW	FX_TEXMOV
	DW	TEX9B
	DW	#A084
	//---
	DB	0
	DW	FX_M_UP
	DB	128
	DW	FX_TEXMOV
	DW	TEX1A
	DW	#8004
	DB	128+32
	DW	FX_TEXMOV
	DW	TEX1B
	DW	#8084
	DB	128+33
	DW	SETVAR_UP
	DB	1,2	//1,2
	//---
	DB	0
	DW	FX_M_DW
	DB	128
	DW	FX_TEXMOV
	DW	TEX2A
	DW	#A004
	DB	128+32
	DW	FX_TEXMOV
	DW	TEX2B
	DW	#A084
	//-----------
	DB	#FF
IM2_END1
//------------------ im2 routine #BFBF
	ORG	#BFBF
IM2B	PUSH	AF
	LD	A,0
	OR	A
	JR	Z,IM2R
	PUSH	BC,DE,HL
	PUSH	IX,IY
	EXX
	PUSH	HL,DE,BC
	LD	BC,#7FFD
	LD	A,#10
	OUT	(C),A
	CALL	AYPLAY
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	POP	BC,DE,HL
	EXX
	POP	IY,IX
	POP	HL,DE,BC
IM2R	POP	AF
	EI
	RET
IM2_END2
//================================================================================================
//					 					PART1: BEGINTEXT
//================================================================================================
	ORG	#8000
	CALL	INIT1
//-------------
	EI
	HALT
	LD	A,1
	LD	(MUSFLAG),A
//------
BLOOP	EI
	HALT
	CALL	BTRACKER
	LD	A,#15+#08
	LD	(XPAGE),A
	CALL	PAGER
	CALL	DOTCLS1
	//---  
	LD	BC,#7FFD
	LD	A,(XPAGE)
	OUT	(C),A
	CALL	ROLL_L
	CALL	ROLL_R
	CALL	TJUMPUP
	CALL	TJUMPDW
	//---  
	LD	A,#13+#08
	LD	(DPAGE),A
	CALL	DOTOUT1

	EI
	HALT
	CALL	BTRACKER
	LD	A,#17
	LD	(XPAGE),A
	CALL	PAGER
	CALL	DOTCLS2
	//---  
	LD	BC,#7FFD
	LD	A,(XPAGE)
	OUT	(C),A
	CALL	ROLL_L
	CALL	ROLL_R
	CALL	TJUMPUP
	CALL	TJUMPDW
	//---  
	LD	A,#13
	LD	(DPAGE),A
	CALL	DOTOUT2
	JP	BLOOP
//-----------------------------------------
DECDOTS
	LD	A,0-1
	LD	(DOTXSTP),A
	LD	A,2
	LD	(DOTFSTP),A
	LD	(DINCFLG),A
	LD	A,(DOTCNT)
	DEC	A
	LD	(DOTCNT),A
	RET
BTRACKER
//------ inc dot count
; 180 max dots
; 384 steps
	LD	A,3
DINCFLG	EQU	$-1
	DEC	A
	LD	(DINCFLG),A
	JP	NZ,NODINC
	LD	A,3
DOTFSTP	EQU	$-1
	LD	(DINCFLG),A
	LD	A,(DOTCNT)
	CP	174
	JP	Z,NODINC
	CP	1
	JP	Z,NODINC
	ADD	A,1
DOTXSTP	EQU	$-1
	LD	(DOTCNT),A
NODINC
//------
	LD	A,96/2
RINC	EQU	$-1
	DEC	A
	JP	NZ,BTRK1
	LD	HL,VAR_R2
	INC	(HL)
	LD	A,96/2
BTRK1	LD	(RINC),A
//------
	LD	A,255
COUNT1	EQU	$-1
	INC	A
	CP	64*3
	JP	NZ,CNT1
	XOR	A
CNT1	LD	(COUNT1),A
	//---
	LD	HL,B_TRACK
BTRKADR	EQU	$-2
	CP	(HL)
	JP	NZ,BLP1
	LD	A,(HL)
	CP	#FF
	JP	Z,BLP1
	//---
	LD	DE,BRET
	PUSH	DE
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	PUSH	DE
	RET
BRET	LD	(BTRKADR),HL
BLP1	//---
	RET
//-----------------------------------------
; DOTTBL -  
;+0 cos_x2
;+1 x1
;+2 cos_y2
;+3 y1

;SCRPTBL -   x,y   
;h+0	HI SCR_ADR
;h+1	LOW SCR_ADR
;h+2	LOW SCR_ADR_ADD	
;h+3	PIXEL DATA FOR WRITE

DOTCOUNT	EQU	175
DOTSTP		EQU	32-3
SCRPTBL		EQU	#BA00	//512b
VAR_R2		DB	#C0
DOTPAGE		EQU	#13
//-----------------------------------------
INI_SCRPTBL ;---    
	LD	HL,SCRPTBL
	LD	DE,#C000
	LD	B,192
IPT1	LD	A,D
	AND	7
	CP	7
	LD	A,D
	JP	NZ,IPT6
	DEC	A
IPT6	LD	(HL),A
	INC	H
	LD	(HL),E
	DEC	H
	INC	L
	CALL	DOWN_DE
	DJNZ	IPT1
	LD	HL,SCRPTBL+512
	XOR	A
	LD	C,32
IPT4	LD	B,8
IPT2	LD	(HL),A
	INC	L
	DJNZ	IPT2
	INC	A
	DEC	C
	JP	NZ,IPT4
	LD	HL,SCRPTBL+768
IPT5	LD	B,7
	LD	A,%11000000
IPT3	LD	(HL),A
	INC	L
	RRCA
	DJNZ	IPT3
	RLCA
	LD	(HL),A
	INC	L
	DEC	C
	JP	NZ,IPT5
	RET
DOWN_DE	INC	D
	LD	A,D
	AND	7
	RET	NZ
	LD	A,E
	ADD	A,#20
	LD	E,A
	RET	C
	LD	A,D
	SUB	8
	LD	D,A
	RET
//---------------------------------------
;---   (200dots=8400t)
DOTCLS1	LD	(SOHRSP7),SP
	LD	SP,DOTSP1
	JP	DOTCLS
DOTCLS2 LD	(SOHRSP7),SP
	LD	SP,DOTSP2
DOTCLS	XOR	A
	LD	B,DOTCOUNT
DOTC1	POP	HL	 ;10
	LD	(HL),A	 ;7
	DEC	H	 ;4
	LD	(HL),A	 ;7
	DEC	B	 ;4
	JP	NZ,DOTC1 ;10 /42
	LD	SP,0
SOHRSP7	EQU	$-2
	RET
//---------------------------------------
	;---  	200*238=47600t
DOTOUT1	LD	(SOHRSP8),SP
	LD	SP,DOTSP1+DOTCOUNT*2
	JP	DOTOUT
DOTOUT2	LD	(SOHRSP8),SP
	LD	SP,DOTSP2+DOTCOUNT*2
DOTOUT	LD	A,1
DOTFLAG	EQU	$-1
	OR	A
	JP	Z,DOTRET
	LD	BC,#7FFD
	LD	A,(DPAGE)
	OUT	(C),A
	EXX
	LD	H,DOTTBL/256
	LD	A,0
DOTANIM	EQU	$-1
	ADD	A,4
	AND	31
	LD	(DOTANIM),A
	LD	L,A
	LD	BC,DOTSTP
	LD	A,(VAR_R2)
	LD	D,A
	LD	LX,2	;DOTCOUNT
DOTCNT	EQU	$-1
	//---
DOTLP	LD	E,(HL)	;7	calc_X0
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	INC	L	;4
	ADD	A,128	;7
	EX	AF,AF	;4 /40
	//---
	LD	E,(HL)	;7	calc_y0
	INC	L	;4
	LD	A,(DE)	;7
	ADD	A,(HL)	;7
	ADD	A,92	;7 /32
	//---
	EXX
	LD	H,SCRPTBL/256 ;7
	LD	L,A	;4
	LD	D,(HL)	;7
	INC	H	;4
	LD	E,(HL)	;7
	INC	H	;4
	EX	AF,AF	;4
	LD	L,A	;4
	LD	A,(HL)	;7
	INC	H	;4
	ADD	A,E	;4
	LD	E,A	;4
	LD	A,(XPAGE) ;13
	OUT	(C),A	  ;12
	EX	DE,HL	;4
	LD	A,(DE)	;7
	OR	(HL)	;7
	LD	(HL),A	;7
	INC	H
	LD	A,(DE)
	OR	(HL)
	LD	(HL),A	;7
	PUSH	HL	;11
	LD	A,DOTPAGE ;7
DPAGE	EQU	$-1
	OUT	(C),A	  ;12
	EXX		;4 /137
	//---
	ADD	HL,BC	;11
	DEC	LX	;8
	JP	NZ,DOTLP ;10 /29 //238   
DOTRET	LD	SP,0
SOHRSP8	EQU	$-2
NOPPP	RET
//--------------------------
B_TRACK
	DB	0
	DW	NOPPP
	DB	0
	DW	NOPPP
	DB	0
	DW	NOPPP
	//-------------- demarche
	DB	24-12
	DW	RL_INI
	DW	SPR_DE
	//-
	DB	72-20
	DW	RR_INI
	DW	SPR_MA
	//-
	DB	120
	DW	S_UP
	DW	#C860+14
	//-
	DB	120+6
	DW	SNO_UP
	//-
	DB	150
	DW	S_UP
	DW	#C860+12
	DB	150+6+3
	DW	S_DW
	DW	#C860+16
	//-
	DB	168
	DW	SNO_DW
	DB	168+1
	DW	SNO_UP
	//-
	DB	0
	DW	CLRTXT
	DB	1
	DW	CLRTXT
	//----------------- presents
	DB	24-16	;12
	DW	RL_INI
	DW	SPR_PRE
	//-
	DB	72-16	;59
	DW	RR_INI
	DW	SPR_ENT
	//-
	DB	120
	DW	S_UP
	DW	#C860+14
	//-
	DB	120+6
	DW	SNO_UP
	//-
	DB	150
	DW	S_DW
	DW	#C860+10
	DB	150+6+3
	DW	S_UP
	DW	#C860+18
	//-
	DB	168
	DW	SNO_UP
	DB	168+1
	DW	SNO_DW
	//-
	DB	0
	DW	CLRTXT
	DB	1
	DW	CLRTXT
	//----------------- ripped idea
	DB	24-17	;12
	DW	RL_INI
	DW	SPR_RIP
	//-
	DB	72-14	;59
	DW	RR_INI
	DW	SPR_IDE
	//-
	DB	120
	DW	S_UP
	DW	#C860+15
	//-
	DB	120+6
	DW	SNO_UP
	//-
	DB	150
	DW	S_UP
	DW	#C860+11
	DB	150+6+3
	DW	S_DW
	DW	#C860+19
	//-
	DB	168
	DW	SNO_DW
	DB	168+1
	DW	SNO_UP
	//-
	DB	0
	DW	CLRTXT
	DB	1
	DW	CLRTXT
	//----------------- redrawed gfx
	DB	24-20	;12
	DW	RL_INI
	DW	SPR_RED
	//-
	DB	72-11	;59
	DW	RR_INI
	DW	SPR_GFX
	//-
	DB	120
	DW	S_UP
	DW	#C860+14
	//-
	DB	120+6
	DW	SNO_UP
	//-
	DB	150
	DW	S_UP
	DW	#C860+23
	DB	150+6+3
	DW	S_DW
	DW	#C860+8
	//-
	DB	168
	DW	SNO_DW
	DB	168+1
	DW	SNO_UP
	//-
	DB	0
	DW	CLRTXT
	DB	1
	DW	CLRTXT
	//----------------- remixed music
	DB	24-18
	DW	RL_INI
	DW	SPR_REM
	//-
	DB	72-13
	DW	RR_INI
	DW	SPR_MUS
	//-
	DB	120
	DW	S_UP
	DW	#C860+14
	//-
	DB	120+6
	DW	SNO_UP
	//-
	DB	150
	DW	S_UP
	DW	#C860+7
	DB	150+6+3
	DW	S_DW
	DW	#C860+23
	//-
	DB	168
	DW	SNO_DW
	DB	168+1
	DW	SNO_UP
	//-
	DB	0
	DW	CLRTXT
	DB	1
	DW	CLRTXT
	//----------------- special for
	DB	24-21	;12
	DW	RL_INI
	DW	SPR_SPE
	//-
	DB	72-10	;59
	DW	RR_INI
	DW	SPR_FOR
	//-
	DB	120
	DW	S_UP
	DW	#C860+13
	//-
	DB	120+6
	DW	SNO_UP
	//-
	DB	150
	DW	S_DW
	DW	#C860+17
	DB	150+6+3
	DW	S_UP
	DW	#C860+10
	//-
	DB	168
	DW	SNO_UP
	DB	168+1
	DW	SNO_DW
	//-
	DB	0
	DW	CLRTXT
	DB	1
	DW	CLRTXT
	//----------------- aaa party
	DB	2
	DW	DECDOTS

	DB	24-13	;12
	DW	RL_INI
	DW	SPR_AAA
	//-
	DB	72-18	;59
	DW	RR_INI
	DW	SPR_COM
	//-
	DB	120
	DW	S_UP
	DW	#C860+14
	//-
	DB	120+6
	DW	SNO_UP
	//-
	DB	150
	DW	S_UP
	DW	#C860+9
	DB	150+6+3
	DW	S_DW
	DW	#C860+18
	//-
	DB	168
	DW	SNO_DW
	DB	168+1
	DW	SNO_UP
	//-
	DB	48*3	//144
	DW	CLRTXT
	DB	48*3+1
	DW	CLRTXT
	//------------------- logo ( 4)
	DB	178
	DW	OUTLOGO
	//---
	DB	#FF
	
//--------------------------
NODOTS	XOR	A
	LD	(DOTFLAG),A
	RET

OUTLOGO	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),L
	LDIR
	LD	A,#17
	CALL	PAGER
	LD	HL,LOGO_5
	LD	DE,#4000
	CALL	DEPACK
	LD	HL,LOGO_7
	LD	DE,#C000
	CALL	DEPACK
	EI
	HALT
	LD	HL,LOGO5RGB
	LD	DE,#5800
	LD	BC,768
	LDIR
	LD	HL,LOGO7RGB
	LD	DE,#D800
	LD	BC,768
	LDIR
LOGOLP	EI
	HALT
	LD	A,#17
PGFLP0	EQU	$-1
	XOR	#08
	LD	(PGFLP0),A
	LD	BC,#7FFD
	OUT	(C),A
	LD	A,64*3
COUNT2	EQU	$-1
	DEC	A
	LD	(COUNT2),A
	JP	NZ,LOGOLP
SSS
	JP	INIT2
	EI
	HALT
	LD	BC,#7FFD
	LD	A,#10
	OUT	(C),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),L
	LDIR
	
	JP	INIT2
//----------------
CLRTXT	PUSH	HL
	LD	A,(XPAGE)
	LD	BC,#7FFD
	OUT	(C),A
	LD	HL,#C860
	LD	C,8
	XOR	A
	LD	(RL_FLAG),A
	LD	(RR_FLAG),A
CLR0	LD	B,32
CLR1	LD	(HL),A
	INC	L
	DJNZ	CLR1
	LD	L,#60
	INC	H
	DEC	C
	JP	NZ,CLR0
	//--- clr RGB
	LD	HL,#D960
	LD	A,(XPAGE)
	CP	#17
	LD	A,BRGB7
	JP	NZ,CLR2
	LD	A,BRGB5
CLR2	LD	B,32
CLR3	LD	(HL),A
	INC	L
	DJNZ	CLR3
	POP	HL
	RET
//------
SNO_DW	XOR	A
	LD	(TFLAGDW),A
	LD	DE,(TADRDW2)
	JP	SNO
SNO_UP	XOR	A
	LD	(TFLAGUP),A
	LD	DE,(TADRUP2)
SNO	LD	C,BRGB5
	CALL	SNO1
	LD	A,(XPAGE)
	XOR	%00000010
	LD	BC,#7FFD
	OUT	(C),A
	XOR	A
	LD	C,BRGB7
SNO1	PUSH	DE
	DUP	8
	LD	(DE),A
	INC	E
	LD	(DE),A
	DEC	E
	INC	D
	EDUP
	LD	A,C
	LD	D,#D9
	LD	(DE),A
	INC	E
	LD	(DE),A
	POP	DE
	RET
	//---
S_DW	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(TADRDW1),DE
	PUSH	HL
	EX	DE,HL
	LD	BC,#20
	ADD	HL,BC
	LD	(TADRDW2),HL
	POP	HL
	LD	A,#FF
	LD	(TFLAGDW),A
	RET
	//---
S_UP	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(TADRUP1),DE
	PUSH	HL
	EX	DE,HL
	LD	BC,0-#20
	ADD	HL,BC
	LD	(TADRUP2),HL
	POP	HL
	LD	A,#FF
	LD	(TFLAGUP),A
	RET
TJUMPUP	//-----
	LD	A,0
TFLAGUP	EQU	$-1
	OR	A
	RET	Z
	LD	HL,0
TADRUP1	EQU	$-2
	LD	DE,0
TADRUP2	EQU	$-2
	LD	B,8
SUP0	LD	A,(HL)
	LD	(DE),A
	XOR	A
	LD	(HL),A
	INC	L
	INC	E
	LD	A,(HL)
	LD	(DE),A
	XOR	A
	LD	(HL),A
	DEC	L
	DEC	E
	INC	H
	INC	D
	DJNZ	SUP0
	LD	A,#47
	LD	D,#D9
	LD	(DE),A
	INC	E
	LD	(DE),A
	LD	H,#D9
	LD	A,(XPAGE)
	CP	#17
	LD	A,BRGB7
	JP	Z,SUP1
	LD	A,BRGB5
SUP1	LD	(HL),A
	INC	L
	LD	(HL),A
	RET
TJUMPDW	//-----
	LD	A,0
TFLAGDW	EQU	$-1
	OR	A
	RET	Z
	LD	HL,0
TADRDW1	EQU	$-2
	LD	DE,0
TADRDW2	EQU	$-2
	LD	B,8
SDW0	LD	A,(HL)
	LD	(DE),A
	XOR	A
	LD	(HL),A
	INC	L
	INC	E
	LD	A,(HL)
	LD	(DE),A
	XOR	A
	LD	(HL),A
	DEC	L
	DEC	E
	INC	H
	INC	D
	DJNZ	SDW0
	LD	A,#47
	LD	D,#D9
	LD	(DE),A
	INC	E
	LD	(DE),A
	LD	H,#D9
	LD	A,(XPAGE)
	CP	#17
	LD	A,BRGB7
	JP	Z,SDW1
	LD	A,BRGB5
SDW1	LD	(HL),A
	INC	L
	LD	(HL),A
	RET

//------
RL_INI	;  
	LD	DE,#C860
	LD	(RL_ADR),DE
	XOR	A
	LD	(RL_B),A
	INC	A
	LD	(RL_FLAG),A
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(RL_SPR),DE
	RET
ROLL_L	;  
	LD	A,0
RL_FLAG	EQU	$-1
	OR	A
	RET	Z
	LD	HL,(RL_SPR)
	LD	A,(HL)
	OR	A
	JP	Z,RLZ
	DEC	A
	LD	(HL),A
RLZ	INC	HL
	LD	A,(HL)
	LD	(RLSZ1),A
	LD	(RLSZ2),A
	//---
	LD	DE,(RL_ADR) ;clear 
	LD	A,E
	SUB	(HL)
	LD	E,A
	XOR	A
	DUP	8
	LD	(DE),A
	INC	D
	EDUP
	//---
	LD	A,0
RL_B	EQU	$-1
	INC	A
	CP	(HL)
	JP	C,RL0
	LD	A,(HL)	
RL0	LD	(RL_B),A
	LD	(RL_BB),A
	INC	HL
	LD	DE,0
RLSZ2	EQU	$-2
	ADD	HL,DE
	DEC	HL
	LD	DE,(RL_ADR)
	LD	C,8
	//---
RL2	LD	B,0
RL_BB	EQU	$-1
	PUSH	DE
	PUSH	HL
RL1	LD	A,(HL)
	LD	(DE),A
	DEC	HL
	DEC	E
	DJNZ	RL1
	POP	HL
	LD	DE,0
RLSZ1	EQU	$-2
	ADD	HL,DE
	POP	DE
	INC	D
	DEC	C
	JP	NZ,RL2
	//---
	LD	HL,(RL_ADR)
	LD	BC,(RL_B-1)
	LD	H,#D9
	LD	A,#47
RL3	LD	(HL),A
	DEC	L
	DJNZ	RL3
	//---
	LD	HL,(RL_SPR)
	LD	A,(HL)
	OR	A
	RET	Z
	LD	HL,RL_ADR
	INC	(HL)
	RET
//---------
RR_INI	;  
	LD	DE,#C87F
	LD	(RR_ADR),DE
	XOR	A
	LD	(RR_B),A
	INC	A
	LD	(RR_FLAG),A
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(RR_SPR),DE
	RET
ROLL_R	LD	A,0
RR_FLAG	EQU	$-1
	OR	A
	RET	Z
	LD	HL,(RR_SPR)
	LD	A,(HL)
	OR	A
	JP	Z,RRZ
	DEC	A
RRZ	LD	(HL),A
	INC	HL
	LD	A,(HL)
	LD	(RRSZ),A
	//---
	LD	DE,(RR_ADR) ;clear 
	LD	A,E
	ADD	(HL)
	LD	E,A
	XOR	A
	DUP	8
	LD	(DE),A
	INC	D
	EDUP
	//---
	LD	A,0
RR_B	EQU	$-1
	INC	A
	CP	(HL)
	JP	C,RR0
	LD	A,(HL)	
RR0	LD	(RR_B),A
	LD	(RR_BB),A
	INC	HL
	LD	DE,(RR_ADR)
	LD	C,8
	//---
RR2	LD	B,0
RR_BB	EQU	$-1
	PUSH	DE
	PUSH	HL
RR1	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	E
	DJNZ	RR1
	POP	HL
	LD	DE,0
RRSZ	EQU	$-2
	ADD	HL,DE
	POP	DE
	INC	D
	DEC	C
	JP	NZ,RR2
	//---
	LD	HL,(RR_ADR)
	LD	BC,(RR_B-1)
	LD	H,#D9
	LD	A,#47
RR3	LD	(HL),A
	INC	L
	DJNZ	RR3
	//---
	LD	HL,(RR_SPR)
	LD	A,(HL)
	OR	A
	RET	Z
	LD	HL,RR_ADR
	DEC	(HL)
	RET
//---------
SPR_0	DB	0
//---------
RL_SPR	DW	SPR_0
RL_ADR	DW	#4880
RR_SPR	DW	SPR_0
RR_ADR	DW	#489F
//=========================================================
INIT1	LD	A,#80
	OUT	(COVOX),A
	EI
	HALT
	LD	HL,#5AFF
	LD	DE,#5AFE
	LD	BC,6911
	LD	(HL),0
	LDDR
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),BRGB5
	LDIR
	LD	BC,#7FFD
	LD	A,#17
	OUT	(C),A
	LD	HL,#C000
	LD	DE,#C001
	LD	BC,6144
	LD	(HL),L
	LDIR
	LD	(HL),BRGB7
	LD	BC,767
	LDIR
	//---
	LD	BC,#7FFD
	LD	A,#10
	OUT	(C),A
	CALL	AYINIT
	//---
	CALL	INI_SCRPTBL
	//---
	CALL	INI_OTBL
	CALL	FUCK_SIN
	CALL	INI_LTBL
	//---
	CALL	IM2INI
	RET
//------
SPR_DE	DB	12
	DB	5
	INCBIN	"gfx/begintext/spr/DE.C"
SPR_MA	DB	20
	DB	13
	INCBIN	"gfx/begintext/spr/MARCHE.C"
	//---
SPR_PRE	DB	16
	DB	9
	INCBIN	"gfx/begintext/spr/PRES.C"
SPR_ENT	DB	16
	DB	9
	INCBIN	"gfx/begintext/spr/ENTS.C"
	//---
SPR_RIP	DB	17
	DB	12
	INCBIN	"gfx/begintext/spr/RIPPED.C"
SPR_IDE	DB	14
	DB	8
	INCBIN	"gfx/begintext/spr/IDEA.C"
	//---
SPR_RED	DB	20
	DB	17
	INCBIN	"gfx/begintext/spr/REDRAW.C"
SPR_GFX	DB	11
	DB	7
	INCBIN	"gfx/begintext/spr/GFX.C"
	//---
SPR_REM	DB	18
	DB	14
	INCBIN	"gfx/begintext/spr/REMIX.C"
SPR_MUS	DB	13
	DB	10
	INCBIN	"gfx/begintext/spr/MUSIC.C"
	//---
SPR_SPE	DB	21
	DB	18
	INCBIN	"gfx/begintext/spr/SPECIAL.C"
SPR_FOR	DB	10
	DB	7
	INCBIN	"gfx/begintext/spr/FOR.C"
	//---
SPR_AAA	DB	13
	DB	7
	INCBIN	"gfx/begintext/spr/AAA.C"
SPR_COM	DB	18
	DB	11
	INCBIN	"gfx/begintext/spr/COMPO.C"
	//---
LOGO5RGB	INCBIN	"gfx/logo/logorgb5.bin"
LOGO7RGB	INCBIN	"gfx/logo/logorgb7.bin"
LOGO_5		INCBIN	"gfx/logo/logo_5.mlz"
LOGO_7		INCBIN	"gfx/logo/logo_7.mlz"
//----------------------------
DOTSP1	DS	DOTCOUNT*2+2,#C002
DOTSP2	DS	DOTCOUNT*2+2,#C002
//---------------------------------------------
//				SETUP
//---------------------------------------------
SETUP	EI
	HALT
	XOR	A
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),L
	LDIR
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,6144
	LD	(HL),L
	LDIR
	LD	BC,767
	LD	(HL),#47
	LDIR
	//---
	LD	HL,SCRSETU
	LD	DE,#4140+9
	LD	A,14
	CALL	SPROUT
	LD	HL,SELECT
	LD	DE,#41E0+5
	LD	A,20
	CALL	SPROUT
	LD	HL,CVX
	LD	DE,#4920+8
	LD	A,12
	CALL	SPROUT
	LD	HL,NEOGS
	LD	DE,#4940+5
	LD	A,20
	CALL	SPROUT
	LD	HL,USECURS
	LD	DE,#49A0+3
	LD	A,25
	CALL	SPROUT
	LD	HL,SPACE
	LD	DE,#49C0+8
	LD	A,15
	CALL	SPROUT
	LD	HL,DEMAR
	LD	DE,#51C0+8
	LD	A,15
	CALL	SPROUT
	LD	HL,PENTAG
	LD	DE,#51E0+5
	LD	A,22
	CALL	SPROUT
	//---
KEYLP	EI
	HALT
	//--- out covox port
	LD	A,(COVOXH)
	LD	DE,#4920+8+12
	CALL	NUMOUT
	LD	A,(COVOXL)
	LD	DE,#4920+8+12+1
	CALL	NUMOUT	
	//---
	LD	HL,#5920+4
CURADR	EQU	$-2
	LD	A,#47+8*1
	CALL	OUTACUR
	LD	HL,(CURADR)
	LD	A,L
	XOR	%01100000
	LD	L,A
	LD	A,#47
	CALL	OUTACUR

	LD	A,#7F
	IN	A,(#FE)
	BIT	0,A
	JP	Z,STARTDEMO

	LD	A,#FE
	IN	A,(#FE)
	BIT	0,A
	JP	NZ,NOCURS
	LD	A,#EF
	IN	A,(#FE)
	BIT	3,A
	CALL	Z,KEY_UP
	LD	A,#EF
	IN	A,(#FE)
	BIT	4,A
	CALL	Z,KEY_DW
NOCURS	//---
	LD	A,(COVOXS)
	OR	A
	JP	NZ,KEYLP
	LD	HL,#5920+20
	LD	(HL),#47+8
	INC	L
	LD	(HL),#47+8
	DEC	L
	LD	DE,(SETCVXX)
	ADD	HL,DE
	LD	A,0
CURBLNK	EQU	$-1
	INC	A
	AND	7
	LD	(CURBLNK),A
	OR	#48
	LD	(HL),A
	//--- input covox port
	LD	A,#F7
	IN	A,(#FE)
	LD	C,1
	BIT	0,A
	CALL	Z,SETCVX
	INC	C
	BIT	1,A
	CALL	Z,SETCVX
	INC	C
	BIT	2,A
	CALL	Z,SETCVX
	INC	C
	BIT	3,A
	CALL	Z,SETCVX
	INC	C
	BIT	4,A
	CALL	Z,SETCVX
	LD	A,#EF
	IN	A,(#FE)
	INC	C
	BIT	4,A
	CALL	Z,SETCVX
	INC	C
	BIT	3,A
	CALL	Z,SETCVX
	INC	C
	BIT	2,A
	CALL	Z,SETCVX
	INC	C
	BIT	1,A
	CALL	Z,SETCVX
	LD	C,0
	BIT	0,A
	CALL	Z,SETCVX
	LD	A,#FD
	IN	A,(#FE)
	LD	C,10
	BIT	0,A
	CALL	Z,SETCVX
	LD	C,13
	BIT	2,A
	CALL	Z,SETCVX
	LD	C,15
	BIT	3,A
	CALL	Z,SETCVX
	LD	A,#FB
	IN	A,(#FE)
	LD	C,14
	BIT	2,A
	CALL	Z,SETCVX	
	LD	A,#7F
	IN	A,(#FE)
	LD	C,11
	BIT	4,A
	CALL	Z,SETCVX	
	LD	A,#FE
	IN	A,(#FE)
	LD	C,12
	BIT	3,A
	CALL	Z,SETCVX	
	JP	KEYLP
	//---------------
STARTDEMO
	EI
	HALT
	EI
	HALT
	LD	A,8
FADE	EQU	$-1
	DEC	A
	LD	(FADE),A
	OR	#40
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),A
	LDIR
	SUB	#40
	OR	A
	JP	NZ,STARTDEMO
	//---
	LD	HL,COVOXH
	LD	A,(HL)
	INC	HL
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,(HL)
	LD	LX,A
	LD	A,(COVOXS)
	OR	A
	JP	Z,SEEKLP
	//--- init gs
	LD	A,#F4	;cold restart
	CALL	GSCOMM
	LD	A,#0E	; go in covox mode
	CALL	GSCOMM
	LD	LX,179	; gs data register
	//---
SEEKLP	LD	A,50
	PUSH	AF
	EI
	HALT
	POP	AF
	DEC	A
	JP	NZ,SEEKLP+2
	//---
	LD	HL,START
	LD	BC,#8000-START
SEEK1	PUSH	HL
	LD	DE,#237E
	CALL	SEEK
	POP	HL
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,SEEK1
	//---
	LD	HL,START
	LD	BC,#8000-START
SEEK2	PUSH	HL
	LD	DE,#030A
	CALL	SEEK
	POP	HL
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,SEEK2
	JP	#8000
SEEK	LD	A,(HL)
	CP	E	;#7E	;ld a,(hl)
	RET	NZ
	INC	HL
	LD	A,(HL)
	CP	D	;#23	;inc hl
	RET	NZ
	INC	HL
	LD	A,(HL)	;out
	CP	#D3
	RET	NZ
	INC	HL
	LD	A,(HL)	;out (fb)
	CP	#FB
	RET	NZ
	LD	A,LX
	LD	(HL),A
	RET
//------
GSCOM	EQU	187
GSCOMM	OUT	(GSCOM),A
WCLP	IN	A,(GSCOM)
	RRCA
	JR	C,WCLP
	RET
//------
KEY_DW	LD	HL,#5940+4
	LD	(CURADR),HL
	LD	A,1
	LD	(COVOXS),A
	JP	WAITKEY
KEY_UP	LD	HL,#5920+4
	LD	(CURADR),HL
	XOR	A
	LD	(COVOXS),A
	JP	WAITKEY
OUTACUR	LD	B,32-10
KEYL1	LD	(HL),A
	INC	L
	DJNZ	KEYL1
	RET
SETCVX	PUSH	AF
	LD	DE,0
SETCVXX	EQU	$-2
	LD	HL,COVOXH
	ADD	HL,DE
	LD	(HL),C
	LD	A,E
	XOR	1
	LD	(SETCVXX),A
	CALL	WAITKEY
	POP	AF
	RET
WAITKEY XOR	A
	IN	A,(#FE)
	OR	%11100000
	INC	A
	JP	NZ,WAITKEY
	RET
NUMOUT	LD	HL,NUMS
	LD	C,A
	ADD	A,A
	ADD	A,A
	ADD	A,C
	LD	C,A
	LD	B,0
	ADD	HL,BC
	LD	A,1
SPROUT	LD	(SO2+1),A
	LD	C,5
SO2	LD	B,0
	PUSH	DE
SO1	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	E
	DJNZ	SO1
	POP	DE
	INC	D
	DEC	C
	JP	NZ,SO2
	RET	
COVOXH	DB	15
COVOXL	DB	11
COVOXS	DB	0
//------
END_8000
//=========================================================
	ORG	#A000
DOTTBL	INCBIN	"dots_figure/dottbl.tbl"
//------
NUMS	INCBIN	"gfx/setup/nums.spr"
SELECT	INCBIN	"gfx/setup/select.spr"
CVX	INCBIN	"gfx/setup/covox.spr"
NEOGS	INCBIN	"gfx/setup/gsneogs.spr"
SPACE	INCBIN	"gfx/setup/space.spr"
DEMAR	INCBIN	"gfx/setup/demarche.spr"
PENTAG	INCBIN	"gfx/setup/pent.spr"
SCRSETU	INCBIN	"gfx/setup/scroll.spr"
USECURS	INCBIN	"gfx/setup/usecurs.spr"
END_A000
//=========================================================
// PAGE #00 - music
//=========================================================
	ORG	#C000
//----------------- TABLES
		ORG	ORG_TBL
BEGIN_TBL	INCBIN	"music/ay/TABLES.BIN"
END_TBL
		ORG	ORG_TRACK
BEGIN_TRACK	INCBIN	"music/ay/TRACK.BIN"
END_TRACK
		ORG	ORG_PATT
BEGIN_PATT	INCBIN	"music/ay/PATTERNS.BIN"
END_PATT
AYINIT	LD	A,7
	LD	BC,#FFFD
	OUT	(C),A
	LD	B,#BF
	LD	A,#FF
	OUT	(C),A
	LD	HL,BEGIN_TRACK
	LD	DE,ADR_A
	LD	BC,10
	LDIR
	LD	(ADR_PATT),HL
	LD	A,PATTSIZE
	LD	(CURRPOS),A
	RET
//---------------- variables
ADR_A	 DW	0
ADR_B	 DW	0
ADR_C	 DW	0
ADR_E	 DW	0
ADR_R	 DW	0
CURRPOS	 DB	PATTSIZE
ADR_PATT DW	0
END_MODULE
	//---------------------
	SAVEBIN	"bin/SCROLL00.BIN",START,LOADER_END-START
	SAVEBIN	"bin/SCROLL15.BIN",LOADER_END,#8000-LOADER_END
	SAVEBIN	"bin/SCROLL12.BIN",#8000,#C000-#8000
	SAVEBIN	"bin/SCROLL10.BIN",#C000,END_MODULE-#C000
//=========================================================
// PAGE #11 - textures
//=========================================================
	ORG	#C000
	DS	65536-#C000,0	;clear ram
	ORG	#C000
TEX1A	INCBIN	"gfx/textures/texture1.S00"
TEX1B	INCBIN	"gfx/textures/texture1.S01"
TEX2A	INCBIN	"gfx/textures/texture2.S00"
TEX2B	INCBIN	"gfx/textures/texture2.S01"
TEX3A	INCBIN	"gfx/textures/texture3.S00"
TEX3B	INCBIN	"gfx/textures/texture3.S01"
TEX4A	INCBIN	"gfx/textures/texture4.S00"
TEX4B	INCBIN	"gfx/textures/texture4.S01"
TEX5A	INCBIN	"gfx/textures/sosiska.S00"
TEX5B	INCBIN	"gfx/textures/sosiska.S01"
TEX9A	INCBIN	"gfx/textures/texture8x.S00"
TEX9B	INCBIN	"gfx/textures/texture8x.S01"
TEX10A	INCBIN	"gfx/textures/texture10.S01"
TEX2X	INCBIN	"gfx/textures/texture2X.S00"
TEX13A	INCBIN	"gfx/textures/texture13.S00"
TEX13B	INCBIN	"gfx/textures/texture13.S01"
TEND
	//---------------------
	SAVEBIN	"bin/SCROLL11.BIN",#C000,TEND-#C000
//=========================================================
// PAGE #17 - digital samples
//=========================================================
	ORG	#DB00
	DS	65536-#DB00,0	;clear ram
	ORG	#DB00
WAV1	INCBIN "music/wav/kick.wav"	;2
	DS	340,#80
WAV2	INCBIN "music/wav/snare.wav"	;4
	DS	340,#80
WAV3	INCBIN "music/wav/hat.wav"	;6
WAV0	DS	340,#80
//---------------------
WAVTRK2
	DB	2,0,6,0,2,0,6,0
	DB	2,4,2,6,4,2,6,4
WAVTRACK1
	DB	2,0,6,0,4,0,6,0
	DB	6,0,2,0,4,0,6,2
	DB	2,0,6,0,4,0,6,0
	DB	2,4,2,0,4,0,6,0,#FF
WAVTRACK2
	DB	2,0,6,0,4,0,6,0
	DB	6,0,2,0,4,0,6,2
	DB	2,0,6,0,4,0,4,0
	DB	2,4,2,0,4,0,6,0,#FF
WAVTRACK3
	DB	2,0,6,0,4,0,6,0
	DB	6,0,2,0,4,0,6,0
	DB	2,0,6,2,4,0,4,6
	DB	2,4,2,6,4,6,6,4,#FF
WAVTRACK4
	DB	2,0,6,0,4,0,6,0
	DB	6,0,2,2,4,0,6,6
	DB	2,0,0,0,6,0,0,0
	DB	6,0,0,0,4,4,2,0,#FF
WAVTRACK5
	DB	2,0,6,2,4,0,6,0
	DB	6,0,2,2,4,0,6,0
	DB	2,0,2,6,4,0,4,6
	DB	2,4,2,6,4,0,6,6,#FF
WAVTRACK6
	DB	2,0,6,0,4,0,6,0
	DB	6,0,2,2,4,0,6,0
	DB	2,0,0,0,6,0,0,0
	DB	6,0,6,6,4,4,2,6,#FF
WAVTRACK7
	DB	2,0,6,2,4,0,6,0
	DB	6,0,2,6,4,0,6,0
	DB	2,0,6,0,4,6,2,0
	DB	2,4,2,6,4,0,6,6,#FF
WAVTRACK8
	DB	2,0,6,2,4,0,6,0
	DB	6,0,2,6,4,0,6,0
	DB	2,0,2,6,4,0,4,6
	DB	2,4,2,6,4,0,6,6,#FF
WAVTRACK9
	DB	2,0,6,2,4,0,6,0
	DB	6,0,2,2,4,0,6,0
	DB	2,0,2,6,4,0,4,6
	DB	2,4,2,6,4,2,6,4,#FF
WAVTRACKA
	DB	2,0,6,0,4,0,6,0
	DB	6,0,2,0,4,0,6,0
	DB	2,0,6,2,4,0,6,6
	DB	2,4,2,6,4,0,6,0,#FF
WAVPATT//--------------------------
	DW	WAVTRACK1
	DW	WAVTRACK1
	DW	WAVTRACK1
	DW	WAVTRACK2
	//---
	DW	WAVTRACK1
	DW	WAVTRACK1
	DW	WAVTRACK1
	DW	WAVTRACK3
	//---
	DW	WAVTRACK1
	DW	WAVTRACK1
	DW	WAVTRACK1
	DW	WAVTRACK2
	//---
	DW	WAVTRACK1
	DW	WAVTRACK1
	DW	WAVTRACK1
	DW	WAVTRACK3
	//---
	DW	WAVTRACK1
	DW	WAVTRACK2
	DW	WAVTRACK1
	DW	WAVTRACK4
	//---
	DW	WAVTRACK5
	DW	WAVTRACK7
	DW	WAVTRACK5
	DW	WAVTRACK3
	//---
	DW	WAVTRACK5
	DW	WAVTRACK8
	DW	WAVTRACK9
	DW	WAVTRACK6
	//---
	DW	WAVTRACK5
	DW	WAVTRACK7
	DW	WAVTRACK5
	DW	WAVTRACKA
	//---
	DB	#FF
//---------------------
WAVEND
WAVFREE	EQU	65536-WAVEND
	//--------------------
	SAVEBIN	"bin/SCROLL17.BIN",#DB00,WAVEND-#DB00
//=========================================================
// PAGE #13 - dotmul table, line table, text, font
//=========================================================
	ORG	#C000
	DS	65536-#C000,0	;clear ram
	ORG	#C000
	INCBIN	"dots_figure/multbl.tbl"
	//--------------------
TEXT	INCBIN "text_convertor/text.bin"
	DB	0
TEXTEND
LNTBL1	INCBIN	"line_traektory/lntbl1.tbl";
LNTBLSZ	EQU	$-LNTBL1
LNTBL2	INCBIN	"line_traektory/lntbl2.tbl";
	ORG	#F600
FONT	INCBIN	"gfx/font/font2560.bin"

END_MULTBL
	SAVEBIN	"bin/SCROLL13.BIN",#C000,END_MULTBL-#C000
//=========================================================
// DISPLAY VARIABLES
//=========================================================
FREE_6000	EQU	#7E00-END_6000
	DISPLAY	"BEGIN ADR: ",/A,START
	DISPLAY	"LOADER ADR: ",/A,LOADER
	DISPLAY	"LOADER_END: ",/A,LOADER_END
	DISPLAY	"END START CODE (#7E00 max): ",/A,END_6000," - free: ",/A,FREE_6000
	DISPLAY	"END 8000 CODE (#9E00 max): ",/A,END_8000
	DISPLAY	"END A000 CODE (#BE00 max): ",/A,END_A000
	DISPLAY	"TEXTEND (#F600 max): ",/A,TEXTEND
	DISPLAY	"END_MODULE: ",/A,END_MODULE
	DISPLAY	"END IM2 #BF02 (#BFBF max): ",/A,IM2_END1
	DISPLAY	"END IM2 #BFBF (#C000 max): ",/A,IM2_END2
	DISPLAY	"WAV END (PAGE#17): ",/A,WAVEND," - free: ",/A,WAVFREE






