unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TFcolor = record
    ink0: byte;
    ink1: byte;
    pap0: byte;
    pap1: byte;
    end;
  TForm1 = class(TForm)
    Button1: TButton;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Button2: TButton;
    Image2: TImage;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  arr_color: array [0..7,0..7] of TColor;
implementation

{$R *.dfm}



procedure CreatePalette;
begin
arr_color[0,0]:=RGB(0,0,0);
arr_color[0,1]:=RGB(0,0,157);
arr_color[0,2]:=RGB(157,0,0);
arr_color[0,3]:=RGB(157,0,157);
arr_color[0,4]:=RGB(0,157,0);
arr_color[0,5]:=RGB(0,157,157);
arr_color[0,6]:=RGB(157,157,0);
arr_color[0,7]:=RGB(157,157,157);

arr_color[1,0]:=RGB(0,0,115);
arr_color[1,1]:=RGB(0,0,230);
arr_color[1,2]:=RGB(157,0,115);
arr_color[1,3]:=RGB(157,0,230);
arr_color[1,4]:=RGB(0,157,115);
arr_color[1,5]:=RGB(0,157,230);
arr_color[1,6]:=RGB(157,157,115);
arr_color[1,7]:=RGB(157,157,230);

arr_color[2,0]:=RGB(115,0,0);
arr_color[2,1]:=RGB(115,0,157);
arr_color[2,2]:=RGB(230,0,0);
arr_color[2,3]:=RGB(230,0,157);
arr_color[2,4]:=RGB(115,157,0);
arr_color[2,5]:=RGB(115,157,157);
arr_color[2,6]:=RGB(230,157,0);
arr_color[2,7]:=RGB(230,157,157);

arr_color[3,0]:=RGB(115,0,115);
arr_color[3,1]:=RGB(115,0,230);
arr_color[3,2]:=RGB(230,0,115);
arr_color[3,3]:=RGB(230,0,230);
arr_color[3,4]:=RGB(115,157,115);
arr_color[3,5]:=RGB(115,157,230);
arr_color[3,6]:=RGB(230,157,115);
arr_color[3,7]:=RGB(230,157,230);

arr_color[4,0]:=RGB(0,115,0);
arr_color[4,1]:=RGB(0,115,157);
arr_color[4,2]:=RGB(157,115,0);
arr_color[4,3]:=RGB(157,115,157);
arr_color[4,4]:=RGB(0,230,0);
arr_color[4,5]:=RGB(0,230,157);
arr_color[4,6]:=RGB(157,230,0);
arr_color[4,7]:=RGB(157,230,157);

arr_color[5,0]:=RGB(0,115,115);
arr_color[5,1]:=RGB(0,115,230);
arr_color[5,2]:=RGB(157,115,115);
arr_color[5,3]:=RGB(157,115,230);
arr_color[5,4]:=RGB(0,230,115);
arr_color[5,5]:=RGB(0,230,230);
arr_color[5,6]:=RGB(157,230,115);
arr_color[5,7]:=RGB(157,230,230);

arr_color[6,0]:=RGB(115,115,0);
arr_color[6,1]:=RGB(115,115,157);
arr_color[6,2]:=RGB(230,115,0);
arr_color[6,3]:=RGB(230,115,157);
arr_color[6,4]:=RGB(115,230,0);
arr_color[6,5]:=RGB(115,230,157);
arr_color[6,6]:=RGB(230,230,0);
arr_color[6,7]:=RGB(230,230,157);

arr_color[7,0]:=RGB(115,115,115);
arr_color[7,1]:=RGB(115,115,230);
arr_color[7,2]:=RGB(230,115,115);
arr_color[7,3]:=RGB(230,115,230);
arr_color[7,4]:=RGB(115,230,115);
arr_color[7,5]:=RGB(115,230,230);
arr_color[7,6]:=RGB(230,230,115);
arr_color[7,7]:=RGB(230,230,230);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
CreatePalette;
end;

function FindColor(xcolorl,xcolorr:TColor): TFcolor;
var i,j: integer;
begin
for i:=0 to 7 do
  for j:=0 to 7 do
    begin
      if arr_color[i,j]=xcolorl then
        begin
        FindColor.ink0:=i;
        FindColor.ink1:=j;
        end;
    end;
for i:=0 to 7 do
  for j:=0 to 7 do
    begin
      if arr_color[i,j]=xcolorr then
        begin
        FindColor.pap0:=i;
        FindColor.pap1:=j;
        end;
    end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var i,xx,yy:integer;
  i0,i1: integer;
  xcolorl,xcolorr,tmpclr:TColor;
  tempbyte: byte;
  arrid: array [0..1023] of TFColor;
  F: File of byte;
begin
i:=0;
for yy:=0 to 31 do
  begin
  for xx:=0 to 31 do
    begin
    xcolorl:=Image1.Picture.Bitmap.Canvas.Pixels[xx*2,yy];
    xcolorr:=Image1.Picture.Bitmap.Canvas.Pixels[xx*2+1,yy];
//    arrid[i]:=FindColor(xcolorl,xcolorr);
    for i0:=0 to 7 do
      begin
      for i1:=0 to 7 do
        begin
        tmpclr:=arr_color[i0,i1];
        Form1.Caption:=IntToStr(i0)+' - '+IntToStr(i1)+ ' : '
        +IntToStr(xx)+' - '+IntToStr(yy);
        Application.ProcessMessages;
        if (xcolorl=tmpclr) then
          begin
          arrid[i].ink0:=i0;
          arrid[i].ink1:=i1;
          end;
        end;
      end;
    //----------
    for i0:=0 to 7 do
      begin
      for i1:=0 to 7 do
        begin
        tmpclr:=arr_color[i0,i1];
        if (xcolorr=tmpclr) then
          begin
          arrid[i].pap0:=i0;
          arrid[i].pap1:=i1;
          end;
        end;
      end;
    Form1.Image2.Canvas.Brush.Color:=arr_color[arrid[i].ink0,arrid[i].ink1];
    Form1.Image2.Canvas.FillRect(Rect(xx*8,yy*4,xx*8+4,yy*4+4));
    Form1.Image2.Canvas.Brush.Color:=arr_color[arrid[i].pap0,arrid[i].pap1];
    Form1.Image2.Canvas.FillRect(Rect(xx*8+4,yy*4,xx*8+8,yy*4+4));

    inc (i)
    end;
  end;
SaveDialog1.Execute;
AssignFile (F,SaveDialog1.FileName+'.S00');
ReWrite(F);
for i:=0 to 1023 do
  begin
  tempbyte:=arrid[i].ink0+8*arrid[i].pap0;
  Write (F,tempbyte);
  end;
CloseFile(F);
AssignFile (F,SaveDialog1.FileName+'.S01');
ReWrite(F);
for i:=0 to 1023 do
  begin
  tempbyte:=arrid[i].ink1+8*arrid[i].pap1+64;
  Write (F,tempbyte);
  end;
CloseFile(F);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
OpenDialog1.Execute;
Image1.Picture.LoadFromFile(OpenDialog1.FileName);
end;

end.
 