//////////////////////////////////////////////////////////////////////////////////////////////////
// File: TextureBlending.fx
// Author: Chris Smith
// Date Created: 2/24/06
// Description: Blends 2 textures together with a blend map
// Disclaimer: Use this however you want, but I am not responsible for anything
//////////////////////////////////////////////////////////////////////////////////////////////////

float4x4 worldViewProj,world;
texture color1Texture;
texture color2Texture;
texture color3Texture;
texture blendmapTexture;
texture detail;
float fogDist;
float4 g_FogColor;
// Color1 Texture samler
sampler2D color1TextureSampler = sampler_state
{
    Texture = (color1Texture);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

// Color2 Texture samler
sampler2D color2TextureSampler = sampler_state
{
    Texture = (color2Texture);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};



// Blend map texture samler
sampler2D blendmapTextureSampler = sampler_state
{
    Texture = (blendmapTexture);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

sampler2D color3TextureSampler = sampler_state
{
    Texture = (detail);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};


sampler2D color4TextureSampler = sampler_state
{
    Texture = (color3Texture);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

//////////////////////////////////////////////////////////////
//Structures
//////////////////////////////////////////////////////////////

//Application to vertex shader
struct A2V
{ 
    float4 position : POSITION0;
    float2 texCoord : TEXCOORD0;


};

//Vertex shader to pixel shader
struct V2P
{
    float4 position  : POSITION0;
    float2 texCoord  : TEXCOORD0;
    float2 texCoord1 : TEXCOORD1;
    float2 texCoord2 : TEXCOORD2;
    float2 texCoord3 : TEXCOORD3;
    float2 texCoord4 : TEXCOORD4;

  
};

//////////////////////////////////////////////////////////////
//Vertex Shader
//////////////////////////////////////////////////////////////
void VS( in A2V IN, out V2P OUT) 
{
    OUT.position  = mul(IN.position, worldViewProj);
    OUT.texCoord  = IN.texCoord;
    OUT.texCoord1 = IN.texCoord;
    OUT.texCoord2 = IN.texCoord;
    OUT.texCoord3 = IN.texCoord;
    OUT.texCoord4 = IN.texCoord;
   

   /*
    float fogFactor = 1 - saturate((OUT.position.z - fogDist * 0.2f) / (fogDist * 0.8f));
    OUT.fogFactor = fogFactor;
*/

}
float ColorSG,XScale,YScale,X1Scale,X2Scale,Y1Scale,Y2Scale,X3Scale,Y3Scale;
//////////////////////////////////////////////////////////////
//Pixel Shader
//////////////////////////////////////////////////////////////
vector PS( in V2P IN) : COLOR
{
float4 color=float4(1,1,1,1);



//IN.texCoord4.x +=IN.texCoord4.x*1.5;


 IN.texCoord1.x +=IN.texCoord1.x*X1Scale;
IN.texCoord1.y +=IN.texCoord1.y*Y1Scale;


 IN.texCoord.x +=IN.texCoord.x*X2Scale;
IN.texCoord.y +=IN.texCoord.y*Y2Scale;


 IN.texCoord4.x +=IN.texCoord4.x*X3Scale;
IN.texCoord4.y +=IN.texCoord4.y*Y3Scale;
  
    vector TexColor1 = tex2D( color1TextureSampler, IN.texCoord );
    vector TexColor2 = tex2D( color2TextureSampler, IN.texCoord1 );
 vector TexColor3 = tex2D( color4TextureSampler, IN.texCoord4 );
    vector BlendMap  = tex2D( blendmapTextureSampler, IN.texCoord2 );
    


IN.texCoord3.x +=IN.texCoord3.x*XScale;
IN.texCoord3.y +=IN.texCoord3.y*YScale;

 float4 B=tex2D(color3TextureSampler, IN.texCoord3);


//float4 A = (TexColor3 * BlendMap.r)+(TexColor1 * BlendMap.g)+(TexColor2 * BlendMap.b);

float4 A = lerp((TexColor3 * BlendMap.r)+(TexColor1 * BlendMap.g) + (TexColor2 * BlendMap.b),float4(1,1,1,1),ColorSG);

    



color *=A;
color*=B;
return color;
}

//////////////////////////////////////////////////////////////
//Techniques
//////////////////////////////////////////////////////////////
technique TexBlend
{
    pass p0
    {

       vertexshader = compile vs_2_0 VS();
        pixelshader = compile ps_2_0 PS();
    }
}