float4   g_vLightPos[4] = { float4(  3.5f, 1.0f,  5.5f, 1.0f ),
                            float4( -3.5f, 1.0f, -5.5f, 1.0f ),
                            float4(  3.5f, 1.0f, -5.5f, 1.0f ),
                            float4( -3.5f, 1.0f,  5.5f, 1.0f ) };  // Light position in 
float4   g_vLightColor = float4( 0.5f, 0.5f, 0.5f, 1.0f );

float4   g_matDiffuse;              // Diffuse component of material
float4   g_matSpecular;             // Specular component of material
float    g_matPower;                // Specular power of material



float4x4 worldViewProj : WorldViewProjection;

float BlurStart =.8; //max 1 min -1
float BlurWidth =.09; //max 1 min -1
float4 Center;//={0.5,0.5,0,0};

texture Tex:S0;  //main render surface;

sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //set the sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT
{
    float3 position	: POSITION;
    float2 texture0 : TEXCOORD0;



};


struct VS_OUTPUT
{
    float4 hposition : POSITION;

	float2 texture0  : TEXCOORD0;

 
    float4 color	 : COLOR0; 


   
};

struct PS_OUTPUT
{
	float4 color : COLOR;
	
	
	
};



VS_OUTPUT VS( VS_INPUT IN ){    VS_OUTPUT OUT;
	OUT.hposition = mul( worldViewProj, float4(IN.position, 1) );

	OUT.color = float4( 1.0, 1.0, 1.0, 1.0 ); // Pass white as a default color

    	OUT.texture0 = IN.texture0-Center;
	return OUT;
}

float4 PS_RadialBlur(float2 TexC: TEXCOORD0,uniform sampler2D tex): COLOR

{
	int nsamples =16;
    half4 c = 0;
    for(int i=0; i<nsamples; i++) {
    	float scale = BlurStart + BlurWidth*(i/(float) (nsamples-1));
    	c += tex2D(Samp, TexC.xy * scale + Center );
   	}
   	c /= nsamples;
    return c;
} 


float part1value;

float4 PS_WATER(float2 TexC: TEXCOORD0,uniform sampler2D tex): COLOR

{
TexC.y +=cos(TexC.y*30 + part1value)*0.01;
TexC.x +=cos(TexC.x*30+ part1value)*0.01;

	float4 color = tex2D(Samp,TexC);

return color;
} 

float tilex,tiley,tile;

float4 PS_Default(float2 TexC: TEXCOORD0,uniform sampler2D tex): COLOR

{
float4 color = tex2D(Samp,TexC);
return color;
} 

float4 PS_COLOR(float2 TexC: TEXCOORD0,uniform sampler2D tex): COLOR

{

float4 color = tex2D(Samp,TexC);
color.r = color.r*sin(TexC.y*500);
color.b = color.b*sin(TexC.y*500);
color.g = color.b*sin(TexC.y*500);

return color;
} 

float4 PS_TILE(float2 TexC: TEXCOORD0,uniform sampler2D tex): COLOR

{

TexC.y =-cos(TexC.y+tilex)*tile;

TexC.x =-cos(TexC.x+tiley)*tile;

float4 color = tex2D(Samp,TexC);

return color;
} 

float YerValue;
float4 PS20( float2 UV : TEXCOORD0 ) : COLOR0
{


float4 Specular;
   
       

        Specular = g_matSpecular * g_vLightColor;
   UV.y+=YerValue;
    float4 color = tex2D( Samp, UV ) * g_matDiffuse *  g_vLightColor + Specular;
    color.a = g_matDiffuse.a;
    return color;

}




technique Default {
    pass p0  {
		
		VertexShader = compile vs_2_0 VS();
		PixelShader  = compile ps_2_0 PS_Default(Samp);
    }
}

technique COLOR {
    pass p0  {
		
		VertexShader = compile vs_2_0 VS();
		PixelShader  = compile ps_2_0 PS_COLOR(Samp);
    }
}


technique WATER{
    pass p0  {
		
		VertexShader = compile vs_2_0 VS();
		PixelShader  = compile ps_2_0 PS_WATER(Samp);
    }
}

technique TILE{
    pass p0  {
		
		VertexShader = compile vs_2_0 VS();
		PixelShader  = compile ps_2_0 PS_TILE(Samp);
    }
}

technique RadialBlur {
    pass p0  {
		
		VertexShader = compile vs_2_0 VS();
		PixelShader  = compile ps_2_0 PS_RadialBlur(Samp);
    }
}







technique ALPHA
{
    pass Pass0
    {


Lighting=true;
	 Lighting = True;

        LightEnable[0] = True;
        LightType[0] = Point;
        LightPosition[0] = <g_vLightPos[0]>;
        LightRange[0] = 100.0f;
        LightDiffuse[0] = <g_vLightColor>;
        LightSpecular[0] = <g_vLightColor>;
        LightAttenuation0[0] = 1.0f;
        LightAttenuation1[0] = 0.0f;
        LightAttenuation2[0] = 0.0f;

        LightEnable[1] = True;
        LightType[1] = Point;
        LightPosition[1] = <g_vLightPos[1]>;
        LightRange[1] = 100.0f;
        LightDiffuse[1] = <g_vLightColor>;
        LightSpecular[1] = <g_vLightColor>;
        LightAttenuation0[1] = 1.0f;
        LightAttenuation1[1] = 0.0f;
        LightAttenuation2[1] = 0.0f;

        LightEnable[2] = True;
        LightType[2] = Point;
        LightPosition[2] = <g_vLightPos[2]>;
        LightRange[2] = 100.0f;
        LightDiffuse[2] = <g_vLightColor>;
        LightSpecular[2] = <g_vLightColor>;
        LightAttenuation0[2] = 1.0f;
        LightAttenuation1[2] = 0.0f;
        LightAttenuation2[2] = 0.0f;

        LightEnable[3] = True;
        LightType[3] = Point;
        LightPosition[3] = <g_vLightPos[3]>;
        LightRange[3] = 100.0f;
        LightDiffuse[3] = <g_vLightColor>;
        LightSpecular[3] = <g_vLightColor>;
        LightAttenuation0[3] = 1.0f;
        LightAttenuation1[3] = 0.0f;
        LightAttenuation2[3] = 0.0f;


SpecularEnable = false;
        Ambient = float4( 0.0f, 0.0f, 0.0f, 0.0f );
        DiffuseMaterialSource = Material;
        SpecularMaterialSource = Material;
        MaterialAmbient = float4( 0.0f, 0.0f, 0.0f, 0.0f );
        MaterialDiffuse = <g_matDiffuse>;
        MaterialEmissive = float4( 0.0f, 0.0f, 0.0f, 0.0f );
        MaterialSpecular = <g_matSpecular>;
        MaterialPower = <g_matPower>;
VertexShader = compile vs_2_0 VS();
PixelShader = compile ps_2_0 PS20();

}
}







