import java.io.*;
import java.util.ArrayList;

public class hackmann {
	
	static char[][] map;
	static Node[][] nodeMap;
	static Node playerNode;
	static int width = 0;
	static int height = 0;
	static int searchDepthMax;
	static int counter = 0;
	static ArrayList<Node> leafNodes = new ArrayList<Node>();
	static ArrayList<String> paths = new ArrayList<String>();
	static ArrayList<Node> monsters = new ArrayList<Node>();
	static ArrayList<Node> megaCoins = new ArrayList<Node>();
	static ArrayList<ArrayList<Node>> monstersPath = new ArrayList<ArrayList<Node>>();
	
	public static void main(String[] args) throws IOException {
		
		BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
		reader.readLine();
		
		searchDepthMax = 14;
		
		width = Integer.parseInt(reader.readLine());
		height = Integer.parseInt(reader.readLine());
		
		map = new char[height][width];
		nodeMap = new Node[height][width];
		
		String line = null;
		int playerPos = -1;
		
		for(int y = 0; y < height; y++) {
			line = reader.readLine();
			playerPos = line.indexOf("X");
			if(playerPos > 0) {
				playerNode = new Node(playerPos,y);
				findObjects(playerNode);
				nodeMap[y][playerPos] = playerNode;
				playerPos = -1;
			}
			map[y] = line.toCharArray();
		}
		findNeighbours(playerNode);
		findSmartestPath();
	}
	
	static void findPossiblePaths(Node root, int searchDepth) {
		root.visited = true;
		if(searchDepth != searchDepthMax) {
			searchDepth++;
			root.cameFrom = null;
			for(Node child : root.children) {
				if(!child.visited) {
					child.cameFrom = root;
					findPossiblePaths(child, searchDepth);
				}
			}
		}
		else {
			root.ascii = 'Z';
			leafNodes.add(root);
		}
	}
	
	static void findSmartestPath() {
		/*
		 for alle retninger player kan g med en viss depth:
		 	flytt player i gitt retning.
		 		for alle monstre:
		 			beregn korteste vei fra monster til player.
		 			flytt monster neste skritt p korteste vei
		 				 
		 
		 */
		ArrayList<ArrayList<Node>> path = new ArrayList<ArrayList<Node>>();
		if(megaCoins.size() > 0) {
			for(Node n : megaCoins) {
				path.add(a_ztar(playerNode, n));
			}
			
			ArrayList<Node> shortestPath = path.get(0);
			
			for(ArrayList<Node> path2 : path) {
				if(path2.size() < shortestPath.size()) {
					shortestPath = path2;
				}
			}
			
			go(shortestPath.get(shortestPath.size()-2));
		}
		else {
			ArrayList<ArrayList<Node>> monsterpath2 = new ArrayList<ArrayList<Node>>();
			for(Node monster : monsters) {
				for(Node neighbor : playerNode.children) {
					monsterpath2.add(a_ztar(monster, neighbor));
				}
			}
			
			ArrayList<Node> pathlol = monsterpath2.get(0);
			
			for(ArrayList<Node> path2 : monsterpath2){
				if(path2.size() > pathlol.size()) {
					pathlol = path2;
				}
			}
			
			ArrayList<Node> astar = a_ztar(playerNode, pathlol.get(0));
			
			go(astar.get(0));
		}
		
	}
	
	static void goNode(Node node, Node goTo) {
		Node temp = goTo;
		if(node.x < goTo.x) {
			nodeMap[node.y][node.x-1] = node;
			nodeMap[node.y][node.x] = temp;
			node.x--;
			temp.x++;
		}
		if(node.x > goTo.x) {
			nodeMap[node.y][node.x+1] = node;
			nodeMap[node.y][node.x] = temp;
			node.x++;
			temp.x--;
		}
		if(node.y < goTo.y) {
			nodeMap[node.y-1][node.x] = node;
			nodeMap[node.y][node.x] = temp;
			node.y--;
			temp.y++;
		}
		if(node.y > goTo.y) {
			nodeMap[node.y+1][node.x] = node;
			nodeMap[node.y][node.x] = temp;
			node.y++;
			temp.y--;
		}
	}
	
	static void go(Node node) {
		switch(node.directionFromParent) {
		case UP:
			System.out.println("N");
			break;
		case RIGHT:
			System.out.println("E");
			break;
		case DOWN:
			System.out.println("S");
			break;
		case LEFT:
			System.out.println("W");
			break;
		}
	}
	
	static void findNeighbours(Node node) /*throws IOException*/{
		int y = node.y;
		int x = node.x;
		counter++;
		findObjects(node);
		
		// O Hai guise, I can has neighbours?
		
		//Find neighbour left of node
		if(x != 0 && map[y][x-1] != '#') {
			if(nodeMap[y][x-1] == null) {
				nodeMap[y][x-1] = new Node(x-1,y);
			}
			Node temp = nodeMap[y][x-1];
			if(!node.children.contains(temp)) {
//				temp.directionFromParent = Direction.LEFT;
				node.children.add(temp);
			}
		}
		//Find neighbour right of node
		if(x != width && map[y][x+1] != '#') {
			if(nodeMap[y][x+1] == null) {
				nodeMap[y][x+1] = new Node(x+1,y);				
			}
			Node temp = nodeMap[y][x+1];
			if(!node.children.contains(temp)) {
//				temp.directionFromParent = Direction.RIGHT;
				node.children.add(temp);
			}
		}
		//Find neighbour down from node
		if(y != 0 && map[y-1][x] != '#') {
			if(nodeMap[y-1][x] == null) {
				nodeMap[y-1][x] = new Node(x,y-1);
			}
			Node temp = nodeMap[y-1][x];
			if(!node.children.contains(temp)) {
//				temp.directionFromParent = Direction.DOWN;
				node.children.add(temp);
			}
		}
		//Find neighbour up from node
		if(y != height && map[y+1][x] != '#') {
			if(nodeMap[y+1][x] == null) {
				nodeMap[y+1][x] = new Node(x,y+1);
			}
			Node temp = nodeMap[y+1][x];
			if(!node.children.contains(temp)) {
//				temp.directionFromParent = Direction.UP;
				node.children.add(temp);
			}
		}
		
		if(node.children.size() == 1) {
			node.deadend = true;
		}
		node.processed = true;
		
		//Recursively search the entire map for neighbors;
		for(Node n : node.children) {
			if(!n.processed) findNeighbours(n);
		}
	}
	
	static void findObjects(Node n) {
		//Assign values and points to the node
		char g = map[n.y][n.x];
		n.ascii = g;
		if(g == '.') {
			n.type = Type.COIN;
			n.points = 10;
		}
		else if(g == 'o') {
			n.type = Type.MEGACOIN;
			n.points = 500;
			megaCoins.add(n);
		}
		else if(g == 'M') {
			n.type = Type.MONSTER;
			monsters.add(n);
		}
		else if(g == 'X') {
			n.type = Type.PLAYER;
		}
		else {
			n.type = Type.EMPTY;
		}
	}
	
	//A-star finding shortest path from startnode to endnode
	static ArrayList<Node> a_ztar(Node start, Node target) {
		ArrayList<Node> closed = new ArrayList<Node>();
		ArrayList<Node> open = new ArrayList<Node>();
		open.add(start);
		start.cameFrom = target.cameFrom = null;
		target.cameFrom = null;
		
		//Node holding the previous processed node
		Node cameFrom;;
		//Node holding the best-case node
		Node bestNode;
		//Initialize f(), g() and h()
		start.gScore = 0;
		start.hScore = heuristicEstimate(start, target);
		start.fScore = start.hScore;
		
		//Distance from root node
		int distance = 0;
		boolean tempIsBetter = false;
		
		//Loop until open has no entries
		while(open.size() > 0) {
			//Store previous node
			bestNode = open.get(0);
			cameFrom = bestNode;
			//Find the node with the best f-score among all open nodes
			for(Node n : open) {
				if(n.fScore > bestNode.fScore) n = bestNode;
			}
			//If we found the target, reconstruct the path from start to target
			if(bestNode == target) {
				return reconstructShortestPath(target);
			}
			//Current node is inspected, add it to closed list.
			open.remove(bestNode);
			closed.add(bestNode);
			distance++;
			
			//Loop through all neighbors and calculate it's f-, g- and hScores
			for(Node n : bestNode.children) {
				n.distanceFromRoot = distance;
				//If node already processed, skip this node
				if(closed.contains(n)) continue;
				//Calculate temporary gScore
				int temp_gScore = n.gScore + n.distanceFromRoot;
				tempIsBetter = false;
				//If this node is not found in the open-list, add it
				if(!open.contains(n)) {
					open.add(n);
					//Calculate heuristic score
					n.hScore = heuristicEstimate(n, target);
					tempIsBetter = true;
				}
				//If we have a better gScore
				else if(temp_gScore < n.gScore) {
					tempIsBetter = true;
				}
				//Store the parent and fScore
				if(tempIsBetter) {
					n.cameFrom = bestNode;
					n.gScore = temp_gScore;
					n.fScore = n.gScore + n.hScore;
				}
			}
		}
		return null;
	}

	static ArrayList<Node> reconstructShortestPath(Node target) {
		ArrayList<Node> path = new ArrayList<Node>();
		while(target.cameFrom != null) {
			path.add(target);
			if(((target.x - 1) == target.cameFrom.x) && target.y == target.cameFrom.y) {
				target.directionFromParent = Direction.RIGHT;
			}
			else if(((target.x + 1) == target.cameFrom.x) && target.y == target.cameFrom.y) {
				target.directionFromParent = Direction.LEFT;
			}
			else if(target.x == target.cameFrom.x && (target.y - 1 == target.cameFrom.y)) {
				target.directionFromParent = Direction.DOWN;
			}
			else if(target.x == target.cameFrom.x && (target.y + 1 == target.cameFrom.y)) {
				target.directionFromParent = Direction.UP;
			}
			
			target = target.cameFrom;
		}
		path.add(target);
		return path;
	}
	
	static int heuristicEstimate(Node start, Node target) {		
		return Math.abs(start.x - target.x) + Math.abs(start.y - target.y);
	}
	
}

class Node {
	
	Direction directionFromParent;
	Node cameFrom;
	char ascii;
	Type type;
	boolean deadend = false;
	ArrayList<Node> children = new ArrayList<Node>();
	
	int gScore = 0;
	int hScore = 0;
	int fScore = 0;
	
	int distanceFromRoot = 0;
	
	boolean processed = false;
	boolean visited = false;
	int originalx, originaly = 0;
	int x, y = 0;
	int points = 0;
	
	public Node(int x, int y) {
		this.x = x;
		this.y = y;
	}
	
	@Override
	public String toString() {
		String typeIs = "";
		switch (type) {
		case EMPTY:
			typeIs = " :";
			break;
		case MONSTER:
			typeIs = "Monster: ";
			break;
		case COIN:
			typeIs = "Coin: ";
			break;
		case PLAYER:
			typeIs = "Player: ";
			break;
		case MEGACOIN:
			typeIs = "Megacoin: ";
			break;
		}
		switch (directionFromParent)
		{
		case UP:
			return typeIs + "UP";
		case DOWN:
			return typeIs + "DOWN";
		case LEFT:
			return typeIs + "LEFT";
		case RIGHT:
			return typeIs + "RIGHT";
		}
		return "typeIs";
	}
	
	public Direction directionFrom(Node neighbor) {
		if(neighbor.x < x) {
			return Direction.LEFT;
		}
		else if(neighbor.x > x) {
			return Direction.RIGHT;
		}
		else if(neighbor.y < y) {
			return Direction.UP;
		}
		else if(neighbor.y > y) {
			return Direction.DOWN;
		}
		return null;
	}
}

enum Direction {
	UP, RIGHT, DOWN, LEFT;
}
enum Type {
	COIN, MEGACOIN, MONSTER, PLAYER, EMPTY;
}