#include <cstdio>
#include <iostream>
#include <cmath>
#include <cstring>

double size = 0;
const char* leveltext = "############################\n\
#......##..........##...M..#\n\
#o####.##.########.##.####o#\n\
#.####.##.########.##.####.#\n\
#........M.................#\n\
###.##.#####.##.#####.##.###\n\
  #.##.#####.##.#####.##.#  \n\
###.##.#####.##.#####.##.###\n\
#  .##.......##.......##.  #\n\
###.##### ######## #####.###\n\
  #.##### ######## #####.#  \n\
  #.         M          .#  \n\
  #.##### ######## #####.#  \n\
  #.##### #      # #####.#  \n\
  #.##    #      #    ##.#  \n\
  #.## ## #      # ## ##.#  \n\
###.## ## ######## ## ##.###\n\
#  .   ##          ##   .  #\n\
###.######## ## ########.###\n\
  #.######## ## ########.#  \n\
  #.......   ##   .......#  \n\
  #.#####.########.#####.#  \n\
###.#####.########.#####.###\n\
#...........X. ............#\n\
#.####.#####.##.#####.####.#\n\
#.####.#####.##.#####.####.#\n\
#.####.##....##....##.####.#\n\
#o####.##.########.##.####o#\n\
#.####.##.########.##.####.#\n\
#..........................#\n\
############################\n";

struct level {
    int maxMoves, width, height;
    char **grid;
};

static inline double const MaxDepth(level* out){
	return 4*sqrt((double)out->width*out->height);
}

void copyLevel(level *in, level *out) {
    out->grid = new char *[in->width];
    for (int x = 0; x < in->width; x++) {
        out->grid[x] = new char[in->height];
        memcpy(out->grid[x], in->grid[x], in->height);
    }

    /*for (int y = 0; y < in->height; y++) {
        for (int x = 0; x < in->width; x++) {
            out->grid[x][y] = in->grid[x][y];
        }
    }
    */
}

struct position {
    int x, y;
};

int getMaxPos(int array[4]) {
    int max = 0, pos = -1;

    for (int i = 0; i < 4; i++) {
        if (array[i] > max) {
            max = array[i];
            pos = i;
        }
    }

    return pos;
}

void printGrid(level *map, position curPos) {
	for(int y = 0; y < map->height; y++){
		for (int x = 0; x < map->width; x++) {
                    if (x == curPos.x && y == curPos.y) std::cout << 'X';
                    else std::cout << map->grid[x][y];
		}
		printf("\n");
	}
}

int getWeigth(position dest, position pos, level *map, int depth = 0) {
    if (dest.x < 0 || dest.x > map->width || dest.y < 0 || dest.y > map->height)
        return 0;

    int cost = 0;
    switch (map->grid[dest.x][dest.y]) {
    case '#':
        return 0;
        break;
    case ' ':
        cost = 0;
        break;
    case 'M':
        return -100000;
        break;
    case '.':
        cost = 5000;
        break;
    case 'o':
        cost = 60000;
        break;
    default:
        //std::cout << map->grid[pos.x][pos.y] << std::endl;
        throw std::string("Oups, default");
        break;
    }

#ifdef _DEBUG
	printGrid(map, pos);
	 std::cout << std::endl << std::endl;
#endif

    map->grid[pos.x][pos.y] = '#';

    cost /= (depth+1);

    position leftPos = dest, rightPos = dest, upPos = dest, downPos = dest;
    leftPos.x--;
    rightPos.x++;
    upPos.y--;
    downPos.y++;

    int leftCost = getWeigth(leftPos, dest, map, depth++) + cost;
    int rightCost = getWeigth(rightPos, dest, map, depth++) + cost;
    int upCost = getWeigth(upPos, dest, map, depth++) + cost;
    int downCost = getWeigth(downPos, dest, map, depth++) + cost;

    int costs[4] = { leftCost, rightCost, upCost, downCost };

    if (depth > size)
        return 0;

    return costs[getMaxPos(costs)];
}

int main (int argc, char** argv)
{
    level map;

    scanf("%i\n%i\n%i\n", &map.maxMoves, &map.width, &map.height);

    map.grid = new char *[map.width];
    for (int x = 0; x < map.width; x++) map.grid[x] = new char[map.height];

#ifdef _DEBUG
    int row = 0, column = 0;
    for (unsigned int i = 0; i < strlen(leveltext); i++) {
        char current = leveltext[i];
        if (current == '\n') {
            row++;
            column = 0;
        } else {
            map.grid[column][row] = (char)current;
            column++;
        }
    }
#else
	for (int y = 0; y < map.height; y++)
	{
		for (int x = 0; x < map.width; x++)
		{
			map.grid[x][y] = getchar();
		}
		scanf("\n");
	}
	size = MaxDepth(&map);

#endif

    for (int y = 0; y < map.height; y++) {
        for (int x = 0; x < map.width; x++) {
            if (map.grid[x][y] == 'X') {
                //std::cout << "test";

                position pos;
                pos.x = x;
                pos.y = y;

                position leftPos = pos, rightPos = pos, upPos = pos, downPos = pos;
                leftPos.x--;
                rightPos.x++;
                upPos.y--;
                downPos.y++;

                //std::cout << map.grid[x][y];
                level leftLevel = map, rightLevel = map, upLevel = map, downLevel = map;
                copyLevel(&map, &leftLevel);
                copyLevel(&map, &rightLevel);
                copyLevel(&map, &upLevel);
                copyLevel(&map, &downLevel);

                int leftCost = getWeigth(leftPos, pos, &leftLevel);
                //std::cout << "Right yo" << std::endl;
                int rightCost = getWeigth(rightPos, pos, &rightLevel);
                int upCost = getWeigth(upPos, pos, &upLevel);
                int downCost = getWeigth(downPos, pos, &downLevel);

#ifdef _DEBUG
                std::cout << "W=" << leftCost << " E=" << rightCost << " N=" << upCost << " S=" << downCost << std::endl;
#endif

                int costs[4] = { leftCost, rightCost, upCost, downCost };
                int max = getMaxPos(costs);

                switch (max) {
                case 0:
                    // Walk left
                    std::cout << 'W';
                    break;
                case 1:
                    // Walk Right
                    std::cout << 'E';
                    break;
                case 2:
                    // Walk up
                    std::cout << 'N';
                    break;
                case 3:
                    // Walk down
                    std::cout << 'S';
                    break;
                }
            }
        }
    }

    for (int x = 0; x < map.width; x++) delete[] map.grid[x];
    delete[] map.grid;
}
