uniform sampler2D tex;
uniform float resolution;
uniform float mix;

void main()
	{
	float y = gl_TexCoord[0].y * resolution;
	vec4 texCol = texture2D( tex, gl_TexCoord[0].xy );
	float lum = texCol.r + 1.0;
	y -= floor( y / lum ) * lum;
	lum = y < 0.5 ? 0.0 : 1.0;
	
	texCol = texture2D( tex, gl_TexCoord[0].xy + vec2( ( lum - 0.5 ) * 0.003 * texCol.r, 0.0 ) );
	vec4 col = vec4( lum, lum, lum, 1.0 ) * mix + texCol * ( 1.0 - mix );
	
	gl_FragColor = vec4( col.rgb, gl_Color.a );
	}