
uniform sampler2D t_color;
uniform vec2 radius;
uniform float bias;
uniform float scale;



const vec2 pixels[13] = vec2[13](vec2( -6, -6 ),vec2( -5, -5 ),vec2( -4, -4 ),vec2( -3, -3 ),vec2( -2, -2 ),vec2( -1, -1 ),vec2(  0, 0 ),vec2(  1, 1 ),vec2(  2, 2 ),vec2(  3, 3 ),vec2(  4, 4 ),vec2(  5, 5 ),vec2(  6, 6 ));

const float weights[13] =
float[13](
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216
);


void main(void) {
	vec2 texcoord = gl_TexCoord[0].xy;
  vec4 col = vec4(0.0);


  
  for (int i=0; i<13; i++) {
    col += texture2D(t_color, texcoord+pixels[i]*radius)*weights[i];
  }
  col = clamp((col + bias) * scale, 0.0, 1.0);
  gl_FragColor = col;
}



