## blury.vert

void main()
	{
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;
	}

## blury.frag

uniform sampler2D tex;
uniform float blur;
uniform float pixel;

void main()
	{
	float fb = floor( blur );
	float div = fb * fb;
	vec2 coord = gl_TexCoord[0].st - vec2( 0, fb * pixel );
	vec4 color;
	float coef = 1.0;
	
	for ( int i = 0; i < fb; i++ )
		{
		color += texture2D( tex, coord ) * coef;
		coord.y += pixel;
		coef += 1.0;
		}
	color += texture2D( tex, coord ) * coef;
	for ( int i = 0; i < fb; i++ )
		{
		coord.y += pixel;
		coef -= 1.0;
		color += texture2D( tex, coord ) * coef;
		}
	
	color /= div;
	
	gl_FragColor = color;
	}