#include "utils.fx"

float4x4 	g_worldViewProjection;
float			g_noiseOffsetX;
float			g_noiseOffsetY;
float			g_skyUFix;
float			g_brightness;
float			g_contrast;

texture		g_groundTexture;
texture		g_videoTexture;
//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
sampler2D inputTex0 : register(s0);
sampler2D inputTex1 : register(s1);

sampler GroundSampler = sampler_state
{
	Texture = <g_groundTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};

sampler GroundSamplerClamp = sampler_state
{
	Texture = <g_groundTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Clamp;
  AddressV = Clamp;
};

sampler VideoSampler = sampler_state
{
	Texture = <g_videoTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};
	
//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV0  : TEXCOORD0;  // vertex texture coords 
    float2 TextureUV1  : TEXCOORD1;  // vertex texture coords 
    float2 TextureUV2  : TEXCOORD2;  // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT GroundVS( float4 vPos : POSITION, 
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1,
                         float2 vTexCoord2 : TEXCOORD2)
{
    VS_OUTPUT Output;

			Output.Position = mul(vPos, g_worldViewProjection);
			Output.TextureUV0 = vTexCoord0;
		  Output.TextureUV2 = (vTexCoord0-0.5) * 2 + 0.5;
			
			vTexCoord0 *= 2.0;
			if (vPos.z<0) vTexCoord0.y = 1-vTexCoord0.y;
			if (vPos.x<0) vTexCoord0.x = 1-vTexCoord0.x;
			Output.TextureUV1 = vTexCoord0;
			Output.Diffuse = vColor;
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};

float g_happiness; // = 0.0;

float4 GroundPS( float2 uv0 : TEXCOORD0, float4 uv1 : TEXCOORD1, float4 uv2 : TEXCOORD2, float4 color : COLOR0) : COLOR0
{ 
		float4 gCol = tex2D(GroundSampler, uv0) * 0.6;
		float4 gCol2 = tex2D(GroundSamplerClamp, uv2) * 0.6;
		gCol2 -= 0.5;
		gCol2 *= 1.0;
		gCol2 += 0.5;
		float g = gCol2.x*gCol.y*gCol.z;
		g = clamp(g, 0, 1);
		gCol = lerp(gCol, gCol*gCol2, 0);	
		gCol += float4(0.12, 0.11, 0.15, 0)*0.5*g_happiness;
		
		float4 vCol = tex2D(VideoSampler, uv1);
		
		vCol -= 0.5;
		vCol *= 1.2;
		// vCol -= 0.2;
		
		gCol += vCol*0.02;

		float4 col = gCol; // * color;
		
		return col;    
}


technique Ground
{
    pass P0
    {   
        VertexShader = compile vs_3_0 GroundVS( );
        PixelShader  = compile ps_3_0 GroundPS( ); 
    }
}


