//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
sampler2D input : register(s0);
float4 main(float2 uv : TEXCOORD) : COLOR 
{ 
	float offset = 0.003;
	float scale = 1.8f;
	
    float4 Color; 
    float4 OrigColor;
    OrigColor = tex2D (input, uv.xy);
    Color = OrigColor;
    Color -= tex2D(input , uv.xy+offset)*scale; 
		Color += tex2D( input , uv.xy-offset)*scale; 
		Color.rgb = (Color.r+Color.g+Color.b);
		
    return Color * OrigColor;
}


//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique Basic
{
    pass P0
    {          
        VertexShader = null;
        PixelShader  = compile ps_2_0 main();
    }
}
