#include "utils.fx"

float4x4 	g_worldViewProjection;
float		g_blend;

texture		g_inputPlaneTexture;


//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
sampler2D inputTex0 : register(s0);
sampler2D inputTex1 : register(s1);

sampler PlaneSampler = sampler_state
{
	Texture = <g_inputPlaneTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};


//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV0  : TEXCOORD0;  // vertex texture coords 
    float2 TextureUV1  : TEXCOORD1;  // vertex texture coords 
};

VS_OUTPUT PlaneVS( float4 vPos : POSITION, 
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1)
{
    VS_OUTPUT Output;

		Output.Position = mul(vPos, g_worldViewProjection);
		
		Output.Diffuse = vColor;
		Output.Diffuse.w = (40.0/(Output.Position.z)) * g_blend;
				
		Output.TextureUV0 = vTexCoord0;
		Output.TextureUV1 = vTexCoord1;
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


float4 PlanePS( float2 uv0 : TEXCOORD0, float2 uv1 : TEXCOORD1, float4 color : COLOR0) : COLOR0
{ 
		float4 planeCol = tex2D(PlaneSampler, uv0) * color;

    return planeCol; // ocolor;
}


technique Plane
{
    pass P0
    {   
        VertexShader = compile vs_3_0 PlaneVS( );
        PixelShader  = compile ps_3_0 PlanePS( ); 
    }
}


