//--------------------------------------------------------------------------------------
// Globals
//--------------------------------------------------------------------------------------
float4x4 g_mWorldViewProjection;    // World * View * Projection matrix
float4x4 g_mIdentity;

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
sampler2D inputTex0 : register(s0);
sampler2D inputTex1 : register(s1);

//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV0  : TEXCOORD0;  // vertex texture coords 
    // float2 TextureUV1  : TEXCOORD1;  // vertex texture coords 
};

VS_OUTPUT PaintStrokeVS( float4 vPos : POSITION,
												 float4 vNormal : NORMAL,
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1
                         )
{
    VS_OUTPUT output;

		float4x4 worldViewProjection = g_mWorldViewProjection;
		
		float4 pos = vNormal;
		
		output.Position = mul(pos, worldViewProjection);
				
		float4	rotated = vPos;;
		float fsin = sin(vTexCoord1.y);
		float fcos = cos(vTexCoord1.y);
		
		float4x4	rot = g_mIdentity;
		rot[0][0] = fcos;
		rot[0][1] = -fsin;
		rot[1][0] = fsin;
		rot[1][1] = fcos; //  { fcos, -fsin, fsin, fcos };

		rotated = mul(vPos, rot);	
		rotated.z = vPos.z;
		
		output.Position += rotated*(vTexCoord1.x);
		
		output.Diffuse = vColor;
		float a = 23-output.Position.z; // ((vPos.x) * 2.12f);
		// if (a<0) a= 0;
		// a = clamp(a, 0, 1); // * vColor.w;
		a = a*0.12*(vColor.w*0.6);
		if (a<0) a = 0;
		output.Diffuse.w = a;
		
		// output.Diffuse *= a;
		output.TextureUV0 = vTexCoord0;
    
    return output;    
}


VS_OUTPUT PaintStrokeDVS( float4 vPos : POSITION,
												 float4 vNormal : NORMAL,
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1
                         )
{
    VS_OUTPUT output;

		float4x4 worldViewProjection = g_mWorldViewProjection;
		
		float4 pos = vNormal;
		
		output.Position = mul(pos, worldViewProjection);
				
		float4	rotated = vPos;;
		float fsin = sin(vTexCoord1.y);
		float fcos = cos(vTexCoord1.y);
		
		float4x4	rot = g_mIdentity;
		rot[0][0] = fcos;
		rot[0][1] = -fsin;
		rot[1][0] = fsin;
		rot[1][1] = fcos; //  { fcos, -fsin, fsin, fcos };

		rotated = mul(vPos, rot);	
		rotated.z = vPos.z;
		
		output.Position += rotated*(vTexCoord1.x);
		
		output.Diffuse = vColor;
		
		// output.Diffuse *= a;
		output.TextureUV0 = vTexCoord0;
    
    return output;    
}

float4 PaintStrokeGroundPS( float2 a_uv0 : TEXCOORD0, float4 a_color : COLOR0) : COLOR0
{ 
	float4 color = tex2D (inputTex0, a_uv0) * a_color * 0.8; ;
	float a = color.w;
	
	color *= a;
	color.w = 1;
	// color *= 10; //sin(color.x*40);
	
	
	/*
		float4 color;
		color.r = a_uv0.x;
		color.g = a_uv0.y;
		color.b = 0;
		color.a = 1;
		return color;
		*/
		
    // return tex2D (inputTex0, a_uv0) * a_color; //  * a_uv0.x;
    
    return color;
}


float4 PaintStrokeBombsPS( float2 a_uv0 : TEXCOORD0, float4 a_color : COLOR0) : COLOR0
{ 
	
	a_color.a = 1;
	float4 color = tex2D (inputTex0, a_uv0);
	float a = color.w;
	
	color *= a_color;
	
	// color *= a;
	color.w = a;
	   
   return color;
}
float4 PaintStrokePicsPS( float2 a_uv0 : TEXCOORD0, float4 a_color : COLOR0) : COLOR0
{ 
	float4 cola = a_color;
	cola.w = 0;
	float4 color = tex2D (inputTex0, a_uv0) * a_color * 0.8 + cola*0.8; // + a_color; ;
	float a = color.w;
	
//	color *= a;
	color.w = a;
	// color *= 10; //sin(color.x*40);
	
	
	/*
		float4 color;
		color.r = a_uv0.x;
		color.g = a_uv0.y;
		color.b = 0;
		color.a = 1;
		return color;
		*/
		
    // return tex2D (inputTex0, a_uv0) * a_color; //  * a_uv0.x;
    
    return color;
}

float4 PaintStrokeBloodPS( float2 a_uv0 : TEXCOORD0, float4 a_color : COLOR0) : COLOR0
{ 
	float4 color = tex2D (inputTex0, a_uv0) * a_color;
	float a = color.w;
	color.x += 0.64;
	color.y -= 0.72;
	color.z -= 0.74;	
	color *= 0.23;
	
//	color *= a;
	color.w = a;
	// color *= 10; //sin(color.x*40);
	
	
	/*
		float4 color;
		color.r = a_uv0.x;
		color.g = a_uv0.y;
		color.b = 0;
		color.a = 1;
		return color;
		*/
		
    // return tex2D (inputTex0, a_uv0) * a_color; //  * a_uv0.x;
    
    return color;
}



technique PaintStrokeGround
{
    pass P0
    {          
        VertexShader = compile vs_3_0 PaintStrokeVS( );
        PixelShader  = compile ps_3_0 PaintStrokeGroundPS( ); 
    }
}


technique PaintStrokeBombs
{
    pass P0
    {          
        VertexShader = compile vs_3_0 PaintStrokeDVS( );
        PixelShader  = compile ps_3_0 PaintStrokeBombsPS( ); 
    }
}


technique PaintStrokePics
{
    pass P0
    {          
        VertexShader = compile vs_3_0 PaintStrokeDVS( );
        PixelShader  = compile ps_3_0 PaintStrokePicsPS( ); 
    }
}


technique PaintStrokeBlood
{
    pass P0
    {          
        VertexShader = compile vs_3_0 PaintStrokeDVS( );
        PixelShader  = compile ps_3_0 PaintStrokeBloodPS( ); 
    }
}

