//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
sampler2D input : register(s0);
float4 main(float2 uv : TEXCOORD, float4 diffuse : COLOR) : COLOR 
{ 
		
		float scale = 1.0f;
		float off = 0.01f;
	
    float4 OrigColor;
    OrigColor = tex2D (input, uv.xy);
    float4 c1 = tex2D (input, uv.xy - off);
    float4 c2 = tex2D (input, uv.xy + off);
    
    float n = OrigColor.r + c1.b*diffuse.g*350 + c2.g;
    uv.xy -= 0.5;
    n += diffuse.r * diffuse.g + uv.x*200 * diffuse.b*20 + uv.y * (50*sin(diffuse.a));
    // n += uv.x*uv.y;
    n = sin(n)*0.15;
		float4 noiseColor = tex2D( input , uv.xy+n)*c1*scale;
		noiseColor += tex2D( input , uv.xy-n)*c2*scale;

    OrigColor = OrigColor * diffuse;
    OrigColor = OrigColor + (noiseColor*0.15);
    
    return OrigColor;
}


//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique Basic
{
    pass P0
    {          
        VertexShader = null;
        PixelShader  = compile ps_2_0 main();
    }
}

